import java.awt.BorderLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * Contains main class
 * Created Mar 25, 2008.
 */
public class Paint extends JFrame {
	private static final int FRAME_HEIGHT = 800;
	private static final int FRAME_WIDTH = 1000;
	private String title;

	/**
	 * Main Paint class
	 *
	 * @param args
	 */
	public Paint(){
		JFrame frame = new JFrame();
		this.title = frame.getName();
	}

	/**
	 * Main method for Paint class.
	 *
	 * @param args
	 */
	public static void main(String[] args) {
	
	Paint frame = new Paint();
	JPanel panel = new JPanel(new BorderLayout());
	
    ToolBar toolBar = new ToolBar();
    ColorBar colorBar = new ColorBar();
    
    PaintCanvas paintCanvas = new PaintCanvas(toolBar, colorBar);
    PaintMenu paintMenu = new PaintMenu(paintCanvas, frame);
    
    
    frame.setJMenuBar(paintMenu);
    panel.add(colorBar, BorderLayout.SOUTH);
    panel.add(toolBar, BorderLayout.EAST);
    panel.add(paintCanvas, BorderLayout.CENTER);
	
    frame.setSize(FRAME_WIDTH, FRAME_HEIGHT);
    frame.add(panel);		
	frame.setVisible(true);
	frame.setTitle("S&W Paint Inc.");
	frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

	}
}
