import java.awt.Dimension;
import java.util.ArrayList;


import javax.swing.ImageIcon;
import javax.swing.JButton;


/**
 * This class represents the tool icon inside the ToolPanel on the left.
 *
 * @author Jared Mathis.
 *         Created Apr 13, 2008.
 */
public class ToolButton extends JButton {
	
	/**
	 * This protected variable represents the size of a button.  It is protected so that other classes can adjust their sizes appropiately.
	 */
	protected static final int BUTTON_SIZE = 22;
	private static final Dimension PREFERRED_SIZE = new Dimension(BUTTON_SIZE, BUTTON_SIZE);
	private static int counter = 0;
	/**
	 * This is protected so that this Paint's drawSpace can interact with the tools.
	 */
	protected static ArrayList<ToolButton> tools = new ArrayList<ToolButton>(0);
	
	/**
	 * The tool number of this Tool.  Refer to ToolPanel for a key of which numbers corresepond to which tool.
	 */
	protected int tool;
	private ImageIcon icon;
	private ImageIcon icon2;
	private boolean isSelected = false;
	private ToolPanel toolPanel;
	
	/**
	 * Constructs a ToolButton
	 *
	 * @param toolPanel The ToolPanel for which this ToolButton belongs in.
	 */
	ToolButton(ToolPanel toolPanel) {
		super();
		
		this.tool = counter++;
		this.icon = new ImageIcon("images/" + ToolPanel.toolIcons[this.tool] + ".gif");
		this.icon2 = new ImageIcon("images/" + ToolPanel.toolIcons[this.tool] + "2.gif");
		this.toolPanel = toolPanel;
		
		this.setIcon(this.icon);
		this.addMouseListener(toolPanel);
		this.setPreferredSize(PREFERRED_SIZE);
		
		this.toolPanel.toolPanel.add(this);
		tools.add(this);
		
		if (this.tool == ToolPanel.DRAW_TOOL) {
			this.setToolTipText("Draw Tool: Click LMB or RMB to initiate. Click either to end.");
		}
		else if (this.tool == ToolPanel.LINE_TOOL) {
			this.setToolTipText("Line Tool: Click LMB or RMB to initiate. Click either to end.");
		}
		else if (this.tool == ToolPanel.POLY_TOOL) {
			this.setToolTipText("Line Tool: Click LMB or RMB to initiate. Click the same MB to continue.  Click the other MB to end.");
		}
		else if (this.tool == ToolPanel.RECT_TOOL) {
			this.setToolTipText("Rectangle Tool: Click LMB or RMB to initiate. Click either to end.");
		}
		else if (this.tool == ToolPanel.FILL_TOOL) {
			this.setToolTipText("Fill Tool: Click LMB or RMB to fill all adjacscent pixels of the same color.");
		}
		else if (this.tool == ToolPanel.EYEDROP_TOOL) {
			this.setToolTipText("Eyedropper Tool: Click LMB or RMB to get the color of the pixel you're hovering over.  Click either MB to select that color.");
		}
		else if (this.tool == ToolPanel.ROUNDBOX_TOOL) {
			this.setToolTipText("Rounded Rectangle Tool: Click LMB or RMB to initiate. Click either to end.");
		}
		else if (this.tool == ToolPanel.OVAL_TOOL) {
			this.setToolTipText("Oval Tool: Click LMB or RMB to initiate. Click either to end.");
		}
		else if (this.tool == ToolPanel.BRUSH_TOOL) {
			this.setToolTipText("Brush Tool: Click LMB or RMB to initiate. Click either to end.");
		}
	}

	/**
	 * Selects a tool.
	 */
	protected void select() {
		this.toolPanel.options.setOptionsTo(ToolOptions.DISABLED);
		
		for (ToolButton tool : tools) {
			tool.isSelected = false;
		}
		this.isSelected = true;
		
		for (ToolButton tool: tools) {
			if (tool.isSelected) tool.setIcon(tool.icon2);
			else tool.setIcon(tool.icon);
		}
		
		if (
				this.tool == ToolPanel.BRUSH_TOOL || 
				this.tool == ToolPanel.LINE_TOOL ||
				this.tool == ToolPanel.POLY_TOOL) {
			this.toolPanel.options.setOptionsTo(ToolOptions.SIZES);
		}
		
		else if (
				this.tool == ToolPanel.RECT_TOOL ||
				this.tool == ToolPanel.ROUNDBOX_TOOL ||
				this.tool == ToolPanel.OVAL_TOOL) {
			this.toolPanel.options.setOptionsTo(ToolOptions.STYLES);
		}
	}
	
	
	
	
}
