import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;


/**
 * This is a class that creates either the size of the line (i.e. for brush tool) or 
 *
 * @author Jared Mathis.
 *         Created Apr 14, 2008.
 */
public class OptionButton extends JButton implements ActionListener {
	
	/**
	 * Heght of an OptionButton.  This is made protected so that ToolOptions can see it and adjust
	 * its dimension size accordingly since ToolOptions holds these things.
	 */
	protected static final int BUTTON_HEIGHT = 15;
	
	/**
	 * Wudth of an OptionButton.  Made protected for same reason as above.
	 */
	protected static final int BUTTON_WIDTH = 45;
	
	private static final Dimension PREFERRED_SIZE = new Dimension(BUTTON_WIDTH, BUTTON_HEIGHT);
	
	/**
	 * The ID number of this OptionButton.  Each number corresponds to either a tool style or size 
	 * (see Paint's currentToolStyle and currentToolSize).  This is made protected so that ToolOptions
	 * can see which OptionButton it has selected.
	 */
	protected int id;
	
	/**
	 * The default (unselected) icon for this OptionButton.  It is protected so that ToolOptions can
	 * access it easily without having to write get/set methods for it.
	 */
	protected ImageIcon defaultIcon;
	
	/**
	 * The icon shown when this OptionButton is selected.  It is protected for the same reason as above.
	 */
	protected ImageIcon selectedIcon;
	private ToolOptions options;
	
	/**
	 * This creates a 
	 *
	 * @param id The ID number of this button; corresponds to either a tool style, or size, depending
	 * on the context.  The same "buttons" are used for both; the icons and functionality just change.
	 * @param options the ToolOptions this OptionButton belongs to.
	 */
	OptionButton(int id, ToolOptions options) {
		super();		
		
		this.id = id;
		this.options = options;
		
		this.addActionListener(this);
		this.setPreferredSize(PREFERRED_SIZE);
	}

	/**
	 * Deselects an option button (really just changes the icon, as you can see).
	 */
	protected void deselect() {
		this.setIcon(this.defaultIcon);
	}
	
	/**
	 * Selects an option button and deselects the rest.
	 */
	protected void select() { 
		this.options.paint.toolPanel.endCurrentTool();
		this.options.deselectAllOptions();		
		this.setIcon(this.selectedIcon);
		if (this.options.status == ToolOptions.SIZES) this.options.paint.currentToolSize = this.id;
		if (this.options.status == ToolOptions.STYLES) this.options.paint.currentToolStyle = this.id;
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this))	this.select();		
	}
}
