import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;

import javax.swing.JPanel;


/**
 * CurrentColor is the two-color thing underneath the tools that show the primary and secondary color.  There is one created
 * for each instance of paint and it belongs to paint's toolPanel.
 *
 * @author Jared Mathis.
 *         Created Apr 11, 2008.
 */
public class CurrentColor extends JPanel implements MouseListener {
	/**
	 * 1/3 the height and width of the CurrentColor viewer.
	 */
	protected static int SIZE = 15;
	/**
	 * Number of pixels between this CurrentColor and the tools JPanel above it.
	 */
	protected static int PADDING = 10;
	
	private Paint paint;
	private Rectangle2D.Double[] grid;
	
	
	/**
	 * Constructs a CurrentColor viewer.
	 *
	 * @param paint The Paint object of this CurrentColor viewer.
	 */
	public CurrentColor(Paint paint) {
		this.paint = paint;
		this.grid = new Rectangle2D.Double[9];
		
		for (int i = 0; i < 3; i++) {
			for (int j = 0; j < 3; j++) {
				this.grid[3 * i + j] = new Rectangle2D.Double(
						i * SIZE, 
						j * SIZE + PADDING, 
						SIZE, 
						SIZE
						);
			}
		}
		
		this.setToolTipText("Click on the color you wish to change, or click on one of the default colors on the bottom of the screen.");
		this.setPreferredSize(new Dimension(SIZE * 3, SIZE * 3 + 2*PADDING));
	}
	
	
	
	@Override
	public void paintComponent(Graphics g) {	
		super.paintComponent(g);
		
		Graphics2D g2 = (Graphics2D)g;
		
		Color[] colors = {
				// This is what the color viewer looks like.
				this.paint.primaryColor,	this.paint.primaryColor,		new Color(0, 0, 0, 0),
				this.paint.primaryColor,	this.paint.primaryColor,		this.paint.secondaryColor,
				new Color(0, 0, 0, 0),		this.paint.secondaryColor,		this.paint.secondaryColor
		};
		
		for (int i = 0; i < 9; i++) {
			g2.setColor(colors[i]);
			g2.fill(this.grid[i]);
		}
	}

	public void mouseClicked(MouseEvent arg0) {
		this.repaint();
		
	}

	public void mouseEntered(MouseEvent arg0) { /* empty */ }
	public void mouseExited(MouseEvent arg0) { /* empty */ }
	public void mousePressed(MouseEvent arg0) { /* empty */ }
	public void mouseReleased(MouseEvent arg0) { /* empty */ }
	
	
}
