import java.awt.Color;
import java.awt.geom.Rectangle2D;

/**
 * creates a rectangle where a start point and end point of the mouse are the opposite
 * corners of the rectangle
 * 
 * @author Joe Wanstrath. Created Mar 27, 2008.
 */
public class Rectangle extends Rectangle2D.Double implements Tool {
	private Color color;

	/**
	 * 
	 * create a rectangle object
	 * 
	 * @param topX
	 *            corner of rectangle
	 * @param topY
	 *            corner of rectangle
	 * @param width
	 *            of rectangle
	 * @param height
	 *            of rectangle
	 * @param canvas
	 *            where to draw the rectangle
	 */
	public Rectangle(double topX, double topY, double width, double height) {	//change to corners instead of widths and height
		super(topX,topY,width,height);
	}

	public void setColor(Color color){
		this.color = color;
	}
	
	public Color getColor(){
		return this.color;
	}
}
