import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;

/**
 * creates buttons with varied backgrounds which will be the color of the
 * objects which it applies to
 * 
 * @author Joe Wanstrath and Dillon Hunt. Created Mar 27, 2008.
 */
public class Colorbar extends JPanel implements ActionListener {

	private String[] ColorList = { "White", "Light Gray", "Red", "Orange",
			"Yellow", "Yellow Green", "Green", "Aqua", "Cyan", "Sky Blue",
			"Blue", "Violet", "Purple", "Magenta", "Dark Gray", "Black" };

	private ArrayList<Colors> buttons = new ArrayList<Colors>();


	/**
	 * 
	 * create a bar of colors to choose from
	 * 
	 * @param canvas
	 *            where to create the colorbar
	 * 
	 */
	public Colorbar() {
		this.setLayout(new GridLayout(2, 8));
		int lighter = 175;
		int darker = 75;
		int r = 0;
		int g = 0;
		int b = 0;
		for (int i = 0; i < this.ColorList.length; i++) {
			if (i == 0 || i >= 2 && i <= 4 || i == 12 || i == 13) {
				r = 255;
			}
			if (i == 0 || i >= 4 && i <= 8) {
				g = 255;
			}
			if (i == 0 || i >= 8 && i <= 12) {
				b = 255;
			}
			if (i == 1 || i == 5 || i == 11) {
				r = lighter;
			}
			if (i == 1 || i == 3 || i == 9) {
				g = lighter;
			}
			if (i == 1 || i == 7 || i == 13) {
				b = lighter;
			}
			if (i == 14) {
				r = darker;
				g = darker;
				b = darker;
			}
			Colors c = new Colors(this.ColorList[i], r, g, b);
			this.buttons.add(c);
			c.addActionListener(this);
			this.add(c);
			r = 0;
			g = 0;
			b = 0;
		}
	}

	/**
	 * 
	 * get color of active button
	 * 
	 * @return active color
	 */
	public Color getActiveColor() {
		for (int i = 0; i < this.buttons.size(); i++) {
			if (this.buttons.get(i).isActive()) {
				return this.buttons.get(i).getBackground();
			}
		}
		return Color.black;
	}

	public void actionPerformed(ActionEvent e) {
		for (int i = 0; i < this.buttons.size(); i++) {
			this.buttons.get(i).setActive(false);
		}
		((Colors) e.getSource()).setActive(true); // activates the most recent
													// clicked button
	}
}
