import java.awt.Color;
import java.awt.geom.Point2D;


/**
 * Creates a new object with a lot of information about itself 
 *
 * @author Hannah Chadd and Annmarie Stanley.
 *         Created Apr 9, 2008.
 */
public class ShapeInfo {
	
	/**
	 * First point used to draw shapes.
	 */
	public Point2D.Double pt1;
	/**
	 * Second point used to draw shapes.
	 */
	public Point2D.Double pt2;
	/**
	 * Width of shape.
	 */
	public double width;
	/**
	 * Height of shape.
	 */
	public double height;
	/**
	 * Type of shape.
	 */
	public int type;
	/**
	 * Color of shape.
	 */
	public int color;
	/**
	 * Current color of shape.
	 */
	public Color nowColor;
	
	/**
	 * Creates the object ShapeInfo
	 *
	 * @param pt1
	 * @param pt2
	 * @param width
	 * @param height
	 * @param type
	 * @param color
	 */
	public ShapeInfo(Point2D.Double pt1, Point2D.Double pt2, double width, double height, int type, int color) {
		this.pt1 = pt1;
		this.pt2 = pt2;
		this.width = width;
		this.height = height;
		this.type = type;
		this.color = color;
		this.nowColor = ColorPanel.COLOR_LIST[this.color];
	}

}
