import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Creates a panel of colored buttons to add to the window.
 *
 * @author Annmarie Stanley and Hannah Chadd.
 *         Created Mar 30, 2008.
 */
public class ColorPanel extends JPanel {

	/** Color currently selected */
	public static Color current = Color.black;

	/** List of colors included in ColorPanel */
	public static final Color [] COLOR_LIST = {Color.BLACK, Color.BLUE, Color.CYAN, 
		Color.DARK_GRAY, Color.GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, 
		Color.ORANGE, Color.RED, Color.PINK, Color.WHITE, Color.YELLOW};
	

	/** Creates the panel of colors to choose from */
	public ColorPanel () {
		this.add(new JLabel("Color Toolbar"));
		JPanel colorPan = new JPanel();
		colorPan.setLayout(new GridLayout(COLOR_LIST.length/2 +1, 2));
		for (Color color : COLOR_LIST) {
			ColorButton cButton = new ColorButton(color);
			cButton.addMouseListener(cButton);
			colorPan.add(cButton);
		}
		this.add(colorPan);
	}
	
}
