import java.awt.Color;

import javax.swing.BorderFactory;
import javax.swing.JPanel;

/**
 * Creates the ToolButtons for the Paint class.
 *
 * @author Pete Brousalis.
 *         Created Apr 14, 2008.
 */
public class ToolButtonPanel extends JPanel{
	/**
	 * Holds all the button names.
	 */
	public static final String[] STANDARD_TOOLS = {
		"Rectangle", "Polygon", "Oval", "Pencil", "Brush", "Text", "Line", "Eraser"
	};
	
	/**
	 * Constructor which creates the buttons dynamically.
	 *
	 * @param paint
	 */
	public ToolButtonPanel(Paint paint) {
	this.setBorder(BorderFactory.createLineBorder(Color.black));
		for (String toolType : STANDARD_TOOLS) {
			ToolButton button = new ToolButton(toolType,paint);
			this.add(button);
			paint.addToolsList(button);
		}
	}
}
