import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

/**
 * Sets up the buttons for ToolButtonPanel
 * Adds a mode changer so CanvasPanel knows what to draw.
 *
 * @author Pete Brousalis.
 *         Created Apr 13, 2008.
 */
public class ToolButton extends JButton implements ActionListener {
	private String toolType;
	private Paint paintField;
	
	private final static int RECT=1,POLY=2,OVAL=3,PENCIL=4, BRUSH=5, TEXT=6, LINE=7, ERASER=8;
	
	/**
	 * Consider yourself... constructed.
	 *
	 * @param toolType
	 * @param paint
	 */
	public ToolButton(String toolType, Paint paint) {
		super(toolType);
		this.toolType = toolType;
		this.paintField = paint;
		this.addActionListener(this);
	}
	
	public void actionPerformed(ActionEvent event) {
		if(this.toolType == "Rectangle"){
			this.paintField.changeMode(RECT);
		}
		if(this.toolType == "Polygon"){
			this.paintField.changeMode(POLY);
		}
		if(this.toolType == "Oval"){
			this.paintField.changeMode(OVAL);
		}
		if(this.toolType == "Pencil"){
			this.paintField.changeMode(PENCIL);
		}
		if(this.toolType == "Brush"){
			this.paintField.changeMode(BRUSH);
		}
		if(this.toolType == "Text"){
			this.paintField.changeMode(TEXT);
		}
		if(this.toolType == "Line"){
			this.paintField.changeMode(LINE);
		}
		if(this.toolType == "Eraser"){
			this.paintField.changeMode(ERASER);
		}
		System.out.println(this.toolType);
	}
}


