import java.awt.Color;

/**
 * Coordinate class for shapes.
 *
 * @author Pete Brousalis.
 *         Created Apr 14, 2008.
 */
public class Coordinate {
	private double x1, y1, x2, y2;
	private int brushWidth;
	private Color foreColor;
	private String message;

	/**
	 * Constructor
	 *
	 * @param inx1
	 * @param iny1
	 * @param inx2
	 * @param iny2
	 * @param color
	 */
	public Coordinate(double inx1, double iny1, double inx2, double iny2,
			Color color) {
		this.x1 = inx1;
		this.y1 = iny1;
		this.x2 = inx2;
		this.y2 = iny2;
		this.foreColor = color;
	}
	
	/**
	 * Constructor
	 *
	 * @param inx1
	 * @param iny1
	 * @param inx2
	 * @param iny2
	 * @param color
	 * @param brushWidth
	 */
	public Coordinate(double inx1, double iny1, double inx2, double iny2,
			Color color, int brushWidth) {
		this.x1 = inx1;
		this.y1 = iny1;
		this.x2 = inx2;
		this.y2 = iny2;
		this.brushWidth = brushWidth;
		this.foreColor = color;
	}
	
	/**
	 * Constructor
	 *
	 * @param inx1
	 * @param iny1
	 * @param inx2
	 * @param iny2
	 * @param color
	 * @param message
	 */
	public Coordinate(int inx1, int iny1, double inx2, double iny2,
			Color color, String message) {
		this.x1 = inx1;
		this.y1 = iny1;
		this.x2 = inx2;
		this.y2 = iny2;
		this.message = message;
		this.foreColor = color;
	}
	
	/**
	 * @return message
	 */
	public String message() {
		return this.message;
	}
	
	/**
	 * @return color
	 */
	public Color color() {
		return this.foreColor;
	}
	
	/**
	 * @return brush width
	 */
	public int brushWidth() {
		return this.brushWidth;
	}

	/**
	 * @return x coord 1
	 */
	public double getX1() {
		return this.x1;
	}

	/**
	 * @return x coord 2
	 */
	public double getX2() {
		return this.x2;
	}

	/**
	 * @return y coord 1
	 */
	public double getY1() {
		return this.y1;
	}

	/**
	 * @return y coord 2
	 */
	public double getY2() {
		return this.y2;
	}
}