import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * Will handle the color chooser panel. Uses JColorChooser
 *
 * @author Pete Brousalis.
 *         Created Apr 11, 2008.
 */
public class ColorButtonPanel extends JPanel  {
	private JButton colorButton, backColorButton;

	private JLabel labelColor, labelBackground, sliderLabel;

	private JSlider slider;
	
	private Color objColor, backColor;

	private CanvasPanel canvasPanel;

	/**
	 * Constructor to the rescue!
	 *
	 * @param myCanvas
	 */
	public ColorButtonPanel(CanvasPanel myCanvas) {
		// sets up canvasPanel
		this.canvasPanel = myCanvas;
		this.setBorder(BorderFactory.createMatteBorder(5,10,5,0,Color.gray));
		
		// setup the color display for the object color
		this.labelColor = new JLabel();
		this.labelColor.setOpaque(true);
		this.labelColor.setBackground(this.canvasPanel.getObjectColor());
		//this.labelColor.setBorder(BorderFactory.createLineBorder(Color.black));

		// setup the color display for the background color
		this.labelBackground = new JLabel();
		this.labelBackground.setOpaque(true);
		this.labelBackground.setBackground(this.canvasPanel.getBackGroundColor());
		//this.labelBackground.setBorder(BorderFactory.createLineBorder(Color.black));
		
		// add color chooser for objects
		this.colorButton = new JButton("Color:");
		this.colorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				setForeGroundColor();
			}
		});

		// add colors chooser for background color
		this.backColorButton = new JButton("Background Color:");
		this.backColorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				setBackGroundColor();
			}
		});
		
		int sliderDefault = 2, sliderMax = 10, sliderMin = 1;
		this.sliderLabel = new JLabel("Width of Brush: " + sliderDefault, SwingConstants.CENTER);
		this.sliderLabel.setAlignmentX(Component.CENTER_ALIGNMENT);

		this.slider = new JSlider(SwingConstants.HORIZONTAL,sliderMin, sliderMax, sliderDefault);
		this.slider.setMajorTickSpacing(2);
		this.slider.setMinorTickSpacing(1);
		this.slider.setPaintTicks(true);
		this.slider.setPaintLabels(true);

		this.slider.addChangeListener(new SliderListener());
		
		// add the objects to the frame!
		this.setLayout(new GridLayout(6, 1));
		this.add(this.colorButton);
		this.add(this.labelColor);
		this.add(this.backColorButton);
		this.add(this.labelBackground);
		this.add(this.sliderLabel);
		this.add(this.slider);

	}

	/**
	 * Uses JColorChooser to chose a color for the objects on the frame.
	 */
	public void setForeGroundColor() {
		this.objColor = JColorChooser.showDialog(null, "Object Color", this.objColor);
		if (this.objColor != null) {
			this.labelColor.setBackground(this.objColor);
			this.canvasPanel.setObjectColor(this.objColor);
		}
	}

	/**
	 * Uses JColorChooser to chose a color for the background
	 * of the frame.
	 */
	public void setBackGroundColor() {
		this.backColor = JColorChooser.showDialog(null, "Background Color", this.backColor);
		if (this.backColor != null) {
			this.labelBackground.setBackground(this.backColor);
			this.canvasPanel.setBackGroundColor(this.backColor);
		}
	}
	
	
	/**
	 * Handles the JSlider for width of brush. Thank you Issac Heyveld for help.
	 *
	 * @author Pete Brousalis.
	 *         Created Apr 14, 2008.
	 */
	class SliderListener implements ChangeListener {
		public void stateChanged(ChangeEvent changeEvent) {
			Object source = changeEvent.getSource();
			if (source instanceof JSlider) {
				JSlider theJSlider = (JSlider) source;
				if (!theJSlider.getValueIsAdjusting()) {
					System.out.println("Slider changed: "+ theJSlider.getValue());
					ColorButtonPanel.this.sliderLabel.setText("Width of Brush: " + theJSlider.getValue());
					ColorButtonPanel.this.canvasPanel.setBrushWidth(theJSlider.getValue());
				}
			}
		}
	}

}