import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


/**
 * Creates the area where the preview of what you will draw is shown.
 *
 * @author Bryce Borchers.
 *         Created Apr 12, 2008.
 */
public class PreviewArea extends JPanel implements ActionListener, ChangeListener {
	
	/**
	 * Creates a new draw area and sets the background to white.
	 */
	public PreviewArea() {
		this.setBackground(Color.WHITE);
	}

	public void actionPerformed(ActionEvent arg0) {
		this.repaint();	
	}

	public void stateChanged(ChangeEvent arg0) {
		this.repaint();
	}
	
	/*
	 * 
	 *  Each draw tool as it's own preivew image.  We check to see what draw tool
	 *  is currently selected and then draw the appropriate image.  For easer and 
	 *  undo their is no image necessary.
	 * 
	 */
	@Override
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D) g;
		
		if (DrawTool.drawTool == "Pencil") {
			Ellipse2D.Double pencil = new Ellipse2D.Double(98, 98, 3, 3);
			g2.setColor(ColorTool.drawColor);
			g2.fill(pencil);
		} else if (DrawTool.drawTool == "Brush") {
			Rectangle2D.Double brush = new Rectangle2D.Double(
					100 - SliderPanel.stroke/2.0, 
					100 - SliderPanel.stroke/2.0, 
					SliderPanel.stroke, 
					SliderPanel.stroke);
			g2.setColor(ColorTool.drawColor);
			g2.fill(brush);
		} else if (DrawTool.drawTool == "Rectangle") {
			Rectangle2D.Double rect = new Rectangle2D.Double(25,60,150,80);
			g2.setColor(ColorTool.drawColor);
			g2.setStroke(new BasicStroke(SliderPanel.stroke/2));
			g2.draw(rect);
		} else if (DrawTool.drawTool == "Oval") {
			Ellipse2D.Double oval = new Ellipse2D.Double(25,60,150,80);
			g2.setColor(ColorTool.drawColor);
			g2.setStroke(new BasicStroke(SliderPanel.stroke/2));
			g2.draw(oval);
		} else if (DrawTool.drawTool == "Polygon") {
			Line2D.Double line1 = new Line2D.Double(25,25,75,75);
			Line2D.Double line2 = new Line2D.Double(75,75,45,175);
			Line2D.Double line3 = new Line2D.Double(45,175,165,175);
			Line2D.Double line4 = new Line2D.Double(165,175,135,50);
			Line2D.Double line5 = new Line2D.Double(135,50,25,25);
			g2.setColor(ColorTool.drawColor);
			g2.draw(line1);
			g2.draw(line2);
			g2.draw(line3);
			g2.draw(line4);
			g2.draw(line5);
		} else if (DrawTool.drawTool == "Spray Paint") {
			g2.setColor(ColorTool.drawColor);
			for (int i=0; i<25; i++) {
				double randx;
				double randy;
				randx = (Math.random() - 0.5) * SliderPanel.stroke * 2;
				randy = (Math.random() - 0.5) * SliderPanel.stroke * 2;
				Ellipse2D.Double spray = new Ellipse2D.Double(
						100 - 1 + randx, 100 - 1 + randy, 2, 2);
				g2.fill(spray);
			}
		} else if (DrawTool.drawTool == "Eraser") {
			// Display nothing in the preview
		} else if (DrawTool.drawTool == "Undo") {
			// Display nothing in the preview
		} else { // Used as a test to make sure we spelled correctly in our if statements.
			System.out.println("This should never print!");
		}
	}
}
