import java.awt.GridLayout;
import javax.swing.JPanel;


/**
 * This class makes a panel that contains buttons for each of our draw tools.
 *
 * @author Bryce Borchers.
 *         Created Mar 27, 2008.
 */
public class ButtonPanel extends JPanel {
	
	/**
	 * Constructs the panel with our 8 different buttons.
	 *
	 */
	public ButtonPanel() {
		this.setLayout(new GridLayout(0,1));
		String [] tools = {"Pencil","Brush","Rectangle","Oval","Polygon","Spray Paint","Eraser","Undo"};
		DrawTool [] buttons = new DrawTool[tools.length];
		for(int i=0; i<tools.length; i++) {
			buttons[i] = new DrawTool(tools[i]);
			this.add(buttons[i]);
		}
	}
}
