import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 * TODO Put here a description of what this class does.
 *
 * @author LPrestonSegoIII.
 *         Created Apr 11, 2008.
 */
public class theMenu extends JMenuBar implements ActionListener{
	private File selectedFile;
	CanvasComponent theCanvas;
	private Paint paint;
	
	   /**
	 * Creates the Menu
	 *
	 * @param canvas
	 * @param paint 
	 */
	public theMenu(CanvasComponent canvas, Paint paint) {
		   this.theCanvas = canvas;
		   this.paint = paint;


	      JMenu fileMenu = new JMenu("File");
	      JMenu editMenu = new JMenu("Edit");
	      JMenu windowMenu = new JMenu("Window");
	
	     JMenuItem createNew = new JMenuItem("New");
         JMenuItem open = new JMenuItem("Open");
         JMenuItem save = new JMenuItem("Save");
         fileMenu.add(createNew);
         fileMenu.insertSeparator(1);
         fileMenu.add(open);
         fileMenu.add(save);

         JMenuItem clearCanvas = new JMenuItem("Clear Canvas");
         JMenuItem changeSize = new JMenuItem("Change Canvas Size");
         editMenu.add(clearCanvas);
         editMenu.add(changeSize);
         
         JMenuItem showColors = new JMenuItem("Show Colors");
         JMenuItem hideColors = new JMenuItem("Hide Colors");
         windowMenu.add(showColors);
         windowMenu.add(hideColors);
         
         createNew.addActionListener(this);
         open.addActionListener(this);
         save.addActionListener(this);
         clearCanvas.addActionListener(this);
         changeSize.addActionListener(this);
         showColors.addActionListener(this);
         hideColors.addActionListener(this);
         
	      add(fileMenu);
	      add(editMenu);
	      add(windowMenu);
	     

	   }
	   
	   /**
	 * Loads an Image
	 *
	 * @throws IOException
	 */
		public void loadImage() throws IOException{
				createFileBrowser("load");
				if(this.selectedFile==null){
					//
				}else{
				BufferedImage image = ImageIO.read(new File(this.selectedFile.toString())); 
				ImageClass test = new ImageClass(image);
				this.theCanvas.setImage(image);
				}
		   }
		public void actionPerformed(ActionEvent e) {
			String menuItem = e.getActionCommand().toString();
			if (menuItem.equals("New")){
			}else if(menuItem.equals("Open")){
				try{
					loadImage();
				}catch(IOException e1){
					System.err.println(e1);
				}
				
			}else if(menuItem.equals("Save")){
				try{
					createFileBrowser("save");
					
					int width = this.theCanvas.getWidth();
					int height = this.theCanvas.getHeight();
					BufferedImage bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
	
					//We have resorted to do this because our previous methods have failed... whcih is sad.. because this
					//doesn't look very nice T_T
					Robot image = null;
					try {
						image = new Robot();
					} catch (AWTException exception) {
						exception.printStackTrace();
					}
					bufferedImage = image.createScreenCapture(new Rectangle(this.theCanvas.getLocationOnScreen().x, this.theCanvas.getLocationOnScreen().y, 
							this.theCanvas.getWidth(), this.theCanvas.getHeight()));
					
					if (this.selectedFile.toString().endsWith(".png")){
						ImageIO.write(bufferedImage, "png", this.selectedFile);				
					}else{
						ImageIO.write(bufferedImage, "png", new File(this.selectedFile.toString() + ".png"));
					}
				}catch(IOException e1){
					System.err.println(e1);
				}
				
				
			}else if(menuItem.equals("Clear Canvas")){
				this.theCanvas.setBackground(Color.BLACK);
				this.theCanvas.setBackground(Color.WHITE);
				
					
			}else if(menuItem.equals("Change Canvas Size")){
				//Ask them what size they want their new thing
				JFrame frame = new JFrame();
				JPanel panel = new JPanel();
				
				panel.setLayout(new BorderLayout());
					JPanel multi = new JPanel();
					multi.setLayout(new GridLayout(2,2));
					
					multi.add(new JLabel("   Width:"));
					JTextField width = new JTextField("500");
					multi.add(width);
			
					
					multi.add(new JLabel("   Height:"));
					JTextField height = new JTextField("500");
					multi.add(height);
						
				panel.add(multi, BorderLayout.NORTH);
				
				JButton button = new JButton("Change Size");
				button.setSize(new Dimension(100,20));
				button.addActionListener(this);
				panel.add(button, BorderLayout.EAST);
				frame.add(panel);
				
				int x = Integer.valueOf(width.getText()).intValue();
				int y = Integer.valueOf(height.getText()).intValue();
				
				frame.setSize(new Dimension(200,100));
				frame.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - frame.WIDTH)/2,
						(Toolkit.getDefaultToolkit().getScreenSize().height - frame.HEIGHT)/2);
				frame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
				frame.setResizable(false);
				
				
				panel.setVisible(true);
				frame.setVisible(true);
				
				this.theCanvas.changeCanvasSize(x, y);
			
			}else if(menuItem.equals("Show Colors")){
				this.paint.showColorChooser();
			}else if(menuItem.equals("Hide Colors")){
				this.paint.hideColorChooser();
			}
			
		}
		
		/**
		 * Creates our File Browser
		 * @param openORsave 
		 *
		 */
		public void createFileBrowser(String openORsave){
			
			JFrame fileBrowser = new JFrame();
			JFileChooser fileChooser = new JFileChooser();
			
			fileBrowser.add(fileChooser);
			fileBrowser.setSize(new Dimension(640, 480));
			fileBrowser.setLocation(new Point(
					Toolkit.getDefaultToolkit().getScreenSize().width/2 - fileBrowser.getWidth()/2,
					Toolkit.getDefaultToolkit().getScreenSize().height/2 - fileBrowser.getHeight()/2));
			
			if (openORsave.equals("load")){
				fileChooser.setDialogTitle("Select image to laod...");
				
			    int result = fileChooser.showOpenDialog(fileBrowser);
			    switch (result) {
				  case JFileChooser.APPROVE_OPTION:
					  this.selectedFile = fileChooser.getSelectedFile();
			        break;
			      case JFileChooser.CANCEL_OPTION:
			        break;
			      case JFileChooser.ERROR_OPTION:
			        break;
			    }
			        
			} else if (openORsave.equals("save")){
				fileChooser.setDialogTitle("Save as File...");
				int action = fileChooser.showSaveDialog(fileBrowser);
				//fileChooser.set(this.paint.jFileName.getText());
				this.selectedFile = fileChooser.getSelectedFile();
		    	   if (this.selectedFile.exists()){
		    		   action = JOptionPane.showConfirmDialog(fileBrowser, "Replace esisting file?");
		    		   if (action != JOptionPane.YES_OPTION){
		    			   return;
		    		   }
		    	   }
			}		
		}
		
		

}
