
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingConstants;


/**
 * The window that contains the buttons and various tools used to draw in the canvas. 
 *
 * @author LPrestonSegoIII
 * 		   Kyle Harris
 *         Created Mar 27, 2008.
 */
public class ToolsComponent extends JPanel implements MouseListener, ChangeListener{

	private int brushSize;
	private JLabel brushSizeLabel;
	private JSlider brushSizeSlider;
	private CanvasComponent canvasComponent;

	/**
	 * The constructor.
	 *
	 * @param canvasComponent
	 */
	public ToolsComponent(CanvasComponent canvasComponent) {
		addMouseListener(this);
		this.canvasComponent = canvasComponent;
		this.brushSizeSlider = new JSlider(SwingConstants.HORIZONTAL, 2, 100, 2);
		this.brushSizeSlider.addChangeListener(this);
		this.brushSizeSlider.setPreferredSize(new Dimension(100, 20));
		this.brushSize = this.brushSizeSlider.getValue();

		
			ToolsButton pencil = new ToolsButton("Pencil", canvasComponent);
			ToolsButton circly = new ToolsButton("Ellipse", canvasComponent);
			ToolsButton rectangle = new ToolsButton("Rectangle", canvasComponent);
			ToolsButton eraser = new ToolsButton("Eraser", canvasComponent);
			ToolsButton brush = new ToolsButton("Paint Brush", canvasComponent);
			ToolsButton polygon = new ToolsButton("Polygon", canvasComponent);
			ToolsButton sprayPaint = new ToolsButton("Spray Paint", canvasComponent);
			
			
			
		this.add(pencil);
		this.add(brush);
		this.add(sprayPaint);
		this.add(circly);
		this.add(rectangle);
		this.add(polygon);
		this.add(eraser);
		this.add(new JLabel("Brush Size:"));
		this.add(this.brushSizeSlider);
		this.brushSizeLabel = new JLabel(Integer.toString(this.brushSize));
		this.add(this.brushSizeLabel);
		
		this.setVisible(true);
		
	}

	

	public void mouseClicked(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}

	public void mouseEntered(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}

	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}

	public void mousePressed(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}

	public void mouseReleased(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}



	public void stateChanged(ChangeEvent arg0) {
		this.brushSize = this.brushSizeSlider.getValue();
		this.brushSizeLabel.setText(Integer.toString(this.brushSizeSlider.getValue()));
		this.canvasComponent.changeBrushSize(this.brushSize);
	}
	
	/**
	 * Returns the currently selected brush size.
	 *
	 * @return the size.
	 */
	public int getBrushSize() {
		return this.brushSizeSlider.getValue();
	}
	
}
