import java.awt.Color;
//import java.awt.event.MouseEvent;
//import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;


/**
 * This class is what makes all of our brush tools
 *
 * @author ian.
 *         Created Mar 23, 2008.
 */
public class Brush extends BufferedImage {
	/**
	 * this field provides x coordinates for all brushes that are built.
	 */
	public int x;
	/**
	 * this field provides y coordinates for all brushes that are built.
	 */
	public int y;
	private int size;
	/**
	 * This is the given name for the brush.
	 */
	String name;
	/**
	 * 
	 * creates a new Brush of width twice the given width
	 * the brushes name is defaulted to its width
	 *
	 * @param size
	 */
	public Brush(int size){
		super(2*size,2*size,TYPE_INT_ARGB);
		this.size=size;
		int[] t = new int[(2*size)*(2*size)];
		for(int i=0;i<t.length;i++){
			t[i]=Color.black.getRGB();
		}
		this.setRGB(0,0,2*size,2*size,t,0,1);
		this.name=size*2+"";
	}
	/**
	 * 
	 * creates a new brush from the specified file of an image, and names it the given name
	 *
	 * @param size width of brush image
	 * @param f the file to be used
	 * @param s  name of the brush
	 */
	public Brush(int size,File f,String s){
		super(size,size,TYPE_INT_ARGB);
		this.size=size/2;
		BufferedImage b =null;
		try {
		b =javax.imageio.ImageIO.read(f);
		}
		catch(IOException e){
			//
		}
		if(b!=null){
			int X=b.getWidth();
			int Y=b.getHeight();
			for(int i=0;i<X;i++){
				for(int j=0;j<Y;j++){
					if(Color.white.getRGB()==getRGB(i,j)){
						Color c;
						c = new Color(getRGB(i,j));
						this.setRGB(i,j,(new Color(c.getRed(),c.getGreen(),c.getBlue(),255)).getRGB());
					}
					else{
						this.setRGB(i,j,b.getRGB(i,j));
					}
				}
			}
		}
		this.name=s;
	}
	/**
	 * 
	 * returns the width of the Brush
	 *
	 * @return the size
	 */
	public int getSize(){
		return this.size;
	}
	/**
	 * 
	 * paints with the brush on the specified canvas at the specified location
	 *
	 * @param c the canvas to paint to
	 * @param x the x coord of the brushes location
	 * @param y the y coord of the brushes location
	 */
	public void Paint(Canvas c,int x,int y){
		int s = 2*this.size;
		for(int i=0;i<s*s;i++){
			try {
				Color painting = c.getPaint().cc.getColor();
				Color t = new Color(this.getRGB(i%s,i/s));
				float alpha = (255-(t.getRed()+t.getBlue()+t.getGreen())/3.0f)/255.0f;
				
				float red = (painting.getRed()*alpha+(1-alpha)*(new Color(c.getImage().getRGB(i%s-this.size+x,i/s-this.size+y)).getRed()))/255;
				float green = (painting.getGreen()*alpha+(1-alpha)*(new Color(c.getImage().getRGB(i%s-this.size+x,i/s-this.size+y)).getGreen()))/255;
				float blue = (painting.getBlue()*alpha+(1-alpha)*(new Color(c.getImage().getRGB(i%s-this.size+x,i/s-this.size+y)).getBlue()))/255;
				red = red>1.0f?1.0f:red;
				green = green>1.0f?1.0f:green;
				blue = blue>1.0f?1.0f:blue;
				Color draw = new Color(red,green,blue);
				if(c.isSelected(i%s-this.size+x,i/s-this.size+y)){
					c.getImage().setRGB(i%s-this.size+x,i/s-this.size+y,draw.getRGB());
				}
			}
			catch(ArrayIndexOutOfBoundsException e){
				continue;
			}
		}
	}
	
	@Override
	public String toString(){
		return (this.name);
	}
}
