import java.awt.geom.Ellipse2D;
import java.util.ArrayList;


/**
 * SprayCan tool
 *
 * @author Richard Stover.
 *         Created Apr 9, 2008.
 */
public class SprayCan implements Tools{
	
	private ArrayList<Ellipse2D> points;
	private float radius;
	private int density;

	/**
	 * creates the spray can
	 *
	 * @param x
	 * @param y
	 * @param f 
	 * @param d 
	 */
	public SprayCan(int x, int y, float f, int d) {
		this.radius = f;
		this.density = d;
		this.points = new ArrayList<Ellipse2D>();
		for(int i=0; i<this.density*20; i++) {
			int j = Math.random() > 0.5 ? -1 : 1;
			int k = Math.random() > 0.5 ? -1 : 1;
			double random = Math.random();
			double angle = Math.random();
			this.points.add(new Ellipse2D.Double((int) (x + j*Math.cos(2*angle*Math.PI)*random*this.radius*5),
					(int) (y + k*Math.sin(2*angle*Math.PI)*random*this.radius*5),2,2));
		}
	}
	
	/**
	 * draws random dots around the mouse point
	 *
	 * @param x
	 * @param y
	 * @return Array of points made from SprayCan
	 */
	public ArrayList<Ellipse2D> draw(int x, int y){
		for(int i=0; i<this.density*20; i++) {
			int j = Math.random() > 0.5 ? -1 : 1;
			int k = Math.random() > 0.5 ? -1 : 1;
			double random = Math.random();
			double angle = Math.random();
			this.points.add(new Ellipse2D.Double((int) (x + j*Math.cos(2*angle*Math.PI)*random*this.radius*5),
					(int) (y + k*Math.sin(2*angle*Math.PI)*random*this.radius*5),2,2));
		}
		return this.points;
	}
	
}