import java.awt.Color;

import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


/**
 * Displays color panel in the Paint frame.
 *
 * @author swansom1.
 *         Created Apr 8, 2008.
 */
public class ColorPanel extends JPanel implements ChangeListener {
	
	private JColorChooser colors;
	private CanvasPanel canvas;
	
	
	/**
	 * Creates color panel.
	 * @param canvas 
	 *
	 */
	ColorPanel(CanvasPanel canvas) {
		super();
		this.canvas = canvas;
		this.colors = new JColorChooser(Color.BLACK);
		this.colors.getSelectionModel().addChangeListener(this);
		this.add(this.colors);
		this.setPreferredSize(this.getMinimumSize());
		this.addMouseWheelListener(this.canvas);
		this.canvas.setColorChooser(this);
	}
	
	/**
	 * returns the choosen color
	 *
	 * @return The JColorChooser
	 */
	public JColorChooser getColorChooser() {
		return this.colors;
	}

	public void stateChanged(ChangeEvent e) {
		Color nextColor = this.colors.getColor();
		this.canvas.setColor(nextColor);
	}

}
