import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

/**
 * Create a straight line
 * 
 * @author Joe Wanstrath. Created Apr 10, 2008.
 */
public class Line extends Line2D.Double implements Tool {
	private Color color;

	/**
	 * 
	 * Construct the line
	 * 
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 */
	public Line(double x1, double x2, double y1, double y2) {
		super(new Point2D.Double(x1, y1), new Point2D.Double(x2, y2));
	}

	
	public Color getColor() {
		return this.color;
	}

	public void setColor(Color color) {
		this.color = color;
		
	}
}
