import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JButton;
import javax.swing.JPanel;


/**
 * This class is a subclass of JPanel.
 * This class creates a panel where the user can choose the color in Paint.
 *
 * @author baekj.
 *         Created Apr 7, 2008.
 */
public class ColorSelectionPanel extends JPanel{
	private static final int C_PANEL_HEIGHT = 200;
	private static final int C_PANEL_WIDTH = 800;
	private DrawingPanel bla;
	
	/**
	 * The constructor creates a Panel with all the buttons and display for
	 * choosing the color for Paint program.
	 *
	 * @param drawing the instance of the panel for drawing. This is brought 
	 * into this class so that the changes in made in this class can affect the 
	 * drawing panel. 
	 */
	public ColorSelectionPanel(DrawingPanel drawing){
		super();
		this.bla = drawing;
		this.setBackground(Color.RED);
		this.setSize(C_PANEL_WIDTH,C_PANEL_HEIGHT);
		
		
		//initialize the display button.
		JButton colorDisplay = new JButton();
		colorDisplay.setSize(50,50);
		colorDisplay.setBackground(Color.BLACK);
		
		//initialize the buttons
		ColorButton button1 = new ColorButton("black",Color.BLACK,this.bla, colorDisplay);
		ColorButton button2 = new ColorButton("white",Color.WHITE,this.bla, colorDisplay);
		ColorButton button3 = new ColorButton("gray",Color.GRAY,this.bla, colorDisplay);
		ColorButton button4 = new ColorButton("silver",new Color(192,192,192),this.bla, colorDisplay);//silver
		ColorButton button5 = new ColorButton("maroon",new Color(128,0,0),this.bla, colorDisplay);//maroon
		ColorButton button6 = new ColorButton("red",new Color(255,0,0),this.bla, colorDisplay);//red
		ColorButton button7 = new ColorButton("olive",new Color(128,128,0),this.bla, colorDisplay);//olive
		ColorButton button8 = new ColorButton("yellow",new Color(255,255,0),this.bla, colorDisplay);//yellow
		ColorButton button9 = new ColorButton("Dark Green",new Color(0,100,0),this.bla, colorDisplay);//Dark Green
		ColorButton button10 = new ColorButton("Green",new Color(0,255,0),this.bla, colorDisplay);//Green
		ColorButton button11 = new ColorButton("Teal",new Color(0,128,128),this.bla, colorDisplay);//Teal
		ColorButton button12 = new ColorButton("Cyan",Color.CYAN,this.bla, colorDisplay);//Cyan
		ColorButton button13 = new ColorButton("Navy Blue",new Color(35,35,142),this.bla, colorDisplay);//Navy Blue
		ColorButton button14 = new ColorButton("blue",Color.BLUE,this.bla, colorDisplay);
		ColorButton button15 = new ColorButton("purple",new Color(128,0,128),this.bla, colorDisplay);//purple
		ColorButton button16 = new ColorButton("magenta",Color.MAGENTA,this.bla, colorDisplay);//magenta
		ColorButton button17 = new ColorButton("old gold",new Color(139,129,76),this.bla, colorDisplay);//old gold
		ColorButton button18 = new ColorButton("lemon yellow",new Color(255,236,139),this.bla, colorDisplay);//lemon yellow
		ColorButton button19 = new ColorButton("slate gray",new Color(47,79,79),this.bla, colorDisplay);//slate gray
		ColorButton button20 = new ColorButton("Kelly green",new Color(0,250,154),this.bla, colorDisplay);//Kelly green
		ColorButton button21 = new ColorButton("Dark Carolina blue",new Color(24,116,205),this.bla, colorDisplay);//Dark Carolina blue
		ColorButton button22 = new ColorButton("aquamarine",new Color(127,255,212),this.bla, colorDisplay);//aquamarine
		ColorButton button23 = new ColorButton("midnight blue",new Color(16,78,139),this.bla, colorDisplay);//midnight blue
		ColorButton button24 = new ColorButton("periwinkle",new Color(89,89,171),this.bla, colorDisplay);//periwinkle
		ColorButton button25 = new ColorButton("Violet-blue",new Color(159,95,159),this.bla, colorDisplay);//Violet-blue
		ColorButton button26 = new ColorButton("Coral",new Color(255,20,147),this.bla, colorDisplay);//Coral
		ColorButton button27 = new ColorButton("Brown",new Color(139,69,19),this.bla, colorDisplay);//Brown
		ColorButton button28 = new ColorButton("Pumpkin Orange",new Color(238,121,66),this.bla, colorDisplay);//Pumpkin Orange
		
		
		button1.addActionListener(button1);
		button2.addActionListener(button2);
		button3.addActionListener(button3);
		button4.addActionListener(button4);
		button5.addActionListener(button5);
		button6.addActionListener(button6);
		button7.addActionListener(button7);
		button8.addActionListener(button8);
		button9.addActionListener(button9);
		button10.addActionListener(button10);
		button11.addActionListener(button11);
		button12.addActionListener(button12);
		button13.addActionListener(button13);
		button14.addActionListener(button14);
		button15.addActionListener(button15);
		button16.addActionListener(button16);
		button17.addActionListener(button17);
		button18.addActionListener(button18);
		button19.addActionListener(button19);
		button20.addActionListener(button20);
		button21.addActionListener(button21);
		button22.addActionListener(button22);
		button23.addActionListener(button23);
		button24.addActionListener(button24);
		button25.addActionListener(button25);
		button26.addActionListener(button26);
		button27.addActionListener(button27);
		button28.addActionListener(button28);
		
		//laying out the buttons
		this.setLayout(new GridBagLayout());
		GridBagConstraints a = new GridBagConstraints();
		GridBagConstraints b = new GridBagConstraints();
		GridBagConstraints c = new GridBagConstraints();
		
		a.gridy = 0;
		a.anchor = GridBagConstraints.CENTER;
		b.gridy = 1;
		b.anchor = GridBagConstraints.CENTER;
		a.weightx = 0.5;
		b.weightx = 0.5;
		
		c.fill = GridBagConstraints.VERTICAL;
		c.gridx = 0;
		c.gridy = 0;
		c.gridheight = 2;
		this.add(colorDisplay, c);
		
		
		a.gridx = 1;
		this.add(button1, a);
		a.gridx = 2;
		this.add(button3, a);
		a.gridx = 3;
		this.add(button5, a);
		a.gridx = 4;
		this.add(button7, a);
		a.gridx = 5;
		this.add(button9, a);
		a.gridx = 6;
		this.add(button11, a);
		a.gridx = 7;
		this.add(button13, a);
		a.gridx = 8;
		this.add(button15, a);
		a.gridx = 9;
		this.add(button17, a);
		a.gridx = 10;
		this.add(button19, a);
		a.gridx = 11;
		this.add(button21, a);
		a.gridx = 12;
		this.add(button23, a);
		a.gridx = 13;
		this.add(button25, a);
		a.gridx = 14;
		this.add(button27, a);
		
		b.gridx = 1;
		this.add(button2, b);
		b.gridx = 2;
		this.add(button4, b);
		b.gridx = 3;
		this.add(button6, b);
		b.gridx = 4;
		this.add(button8, b);
		b.gridx = 5;
		this.add(button10, b);
		b.gridx = 6;
		this.add(button12, b);
		b.gridx = 7;
		this.add(button14, b);
		b.gridx = 8;
		this.add(button16, b);
		b.gridx = 9;
		this.add(button18, b);
		b.gridx = 10;
		this.add(button20, b);
		b.gridx = 11;
		this.add(button22, b);
		b.gridx = 12;
		this.add(button24, b);
		b.gridx = 13;
		this.add(button26, b);
		b.gridx = 14;
		this.add(button28, b);
		
		
		
		this.setVisible(true);
		
	}

}
