# This module is a prototype showing how to use the revised graphics module
# that accepts key presses.  You do not need to do anything with this module, 
# but may want to experiment with it.
#
# by Matt Boutell, 19 Jan 2008
# modifications for Mac OS, Curt Clifton, 19 Jan 2008

from zellekeygraphics import * 

left_arrow  = 'Left'
up_arrow    = 'Up'
right_arrow = 'Right'
down_arrow  = 'Down'
enter_key   = 'Return'

win = GraphWin("Getting keyboard input!", 200, 200)
text = Text(Point(100, 50), "Click once here to set focus")
text.draw(win)
text = Text(Point(100, 80), "then use the arrows. ")
text.draw(win)
text = Text(Point(100, 110), "<enter> to quit. ")
text.draw(win)

counter = 0
while True:
    key = win.checkKey()
    if key == None:
        pass # avoids additional tests
    else:
        counter += 1
        if key == enter_key:
            break
        elif key == left_arrow:
            print "%d. Left" % (counter)
        elif key == right_arrow:
            print "%d. Right" % (counter)
        elif key == up_arrow:
            print "%d. Up" % (counter)
        elif key == down_arrow:
            print "%d. Down" % (counter)
        elif key != None:
            print "%d. Keycode %s was pressed" % (counter,key)
