# Tasks:
#  - Implement method stubs, creating helper methods and fields as needed.
#  - Do not change the test code at the end of the module.

from tetrisTestUtilities import *
from PlayingBoard import *

class Ell:
    """This is an implementation of:
       EEE
       E   """

    def __init__(self, board):
        """Constructs a new Ell piece on the given board."""
        # TODO: implement constructor for Ell
        
    def moveLeft(self):
        """ Moves the piece left if possible; otherwise leaves it unchanged."""
        # TODO: implement moveLeft for Ell
    
    def moveRight(self):
        """ Moves the piece right if possible; otherwise leaves it unchanged."""
        # TODO: implement moveRight for Ell

    def moveDown(self):
        """ Moves the piece down one row if possible, returning True in that case;
        otherwise leaves it unchanged and returns false."""
        # TODO: implement moveDown for Ell

    def drop(self):
        """ Moves the piece down as far as possible."""
        # TODO: implement drop for Ell

    def rotate(self):
        """ Rotates the piece clockwise if possible; otherwise leaves it unchanged."""
        # TODO: implement rotate for Ell


    
#-----------------------------------------------------------------------------
# ELL TESTS -- DO NOT CHANGE
#-----------------------------------------------------------------------------

def moveLeftEllTest():
    printTestName()
    board = PlayingBoard()
    piece = Ell(board)
    verifyBoardSparse("Initial Ell board", 
                      [(0,3),(0,4),(0,5),(1,3)], board)
    piece.moveLeft()
    verifyBoardSparse("Ell board after one moveLeft", 
                      [(0,2),(0,3),(0,4),(1,2)], board)
    doMultipleMoves(piece, -2, 0, 0)
    verifyBoardSparse("Ell board after moving to left edge", 
                      [(0,0),(0,1),(0,2),(1,0)], board)
    piece.moveLeft()
    verifyBoardSparse("Ell board after trying to move left again", 
                      [(0,0),(0,1),(0,2),(1,0)], board)
    print

def moveRightEllTest():
    printTestName()
    board = PlayingBoard()
    piece = Ell(board)
    piece.moveRight()
    verifyBoardSparse("Ell board after one moveRight", 
                      [(0,4),(0,5),(0,6),(1,4)], board)
    doMultipleMoves(piece, 3, 0, 0)
    verifyBoardSparse("Ell board after moving to right edge", 
                      [(0,7),(0,8),(0,9),(1,7)], board)
    piece.moveRight()
    verifyBoardSparse("Ell board after trying to move right again", 
                      [(0,7),(0,8),(0,9),(1,7)], board)
    print
    
def moveDownEllTest():
    printTestName()
    board = PlayingBoard()
    piece = Ell(board)
    verifyTrue("Ell initial moveDown return value", piece.moveDown())
    verifyBoardSparse("Ell board after one moveDown", 
                      [(1,3),(1,4),(1,5),(2,3)], board)
    doMultipleMoves(piece, 0, 14, 0)
    verifyBoardSparse("Ell board after moving one space from bottom edge", 
                      [(15,3),(15,4),(15,5),(16,3)], board)

    verifyTrue("Ell next-to-last moveDown return value", piece.moveDown())
    verifyBoardSparse("Ell board after trying to move down again", 
                      [(16,3),(16,4),(16,5),(17,3)], board)

    verifyFalse("Ell last moveDown return value", piece.moveDown())
    verifyBoardSparse("Ell board after trying to move down again", 
                      [(16,3),(16,4),(16,5),(17,3)], board)
    print

def dropEllTest():
    printTestName()
    board = PlayingBoard()
    piece = Ell(board)
    rotateAndDropHelper(piece, board, 0, [(16,3),(16,4),(16,5),(17,3)])

    board = PlayingBoard()
    piece = Ell(board)
    rotateAndDropHelper(piece, board, 1, [(15,4),(16,4),(17,4),(15,3)])
    
    board = PlayingBoard()
    piece = Ell(board)
    rotateAndDropHelper(piece, board, 2, [(17,3),(17,4),(17,5),(16,5)])

    board = PlayingBoard()
    piece = Ell(board)
    rotateAndDropHelper(piece, board, 3, [(15,4),(16,4),(17,4),(17,5)])

    board = PlayingBoard()
    piece = Ell(board)
    rotateAndDropHelper(piece, board, 0, [(16,3),(16,4),(16,5),(17,3)])
    print

def rotateEllTest():
    printTestName()
    board = PlayingBoard()
    piece = Ell(board)
    # Move piece below top edge to give space to rotate
    doMultipleMoves(piece, 0, 2, 0)
    piece.rotate()
    verifyBoardSparse("Ell board after one rotation", 
                      [(1,4),(2,4),(3,4),(1,3)], board)
    piece.rotate()
    verifyBoardSparse("Ell board after two rotations", 
                      [(2,3),(2,4),(2,5),(1,5)], board)
    piece.rotate()
    verifyBoardSparse("Ell board after three rotations", 
                      [(1,4),(2,4),(3,4),(3,5)], board)
    piece.rotate()
    verifyBoardSparse("Ell board after four rotations", 
                      [(2,3),(2,4),(2,5),(3,3)], board)
    print

def rotateIntoWallEllTest():
    printTestName()
    board = PlayingBoard()
    piece = Ell(board)
    # Move piece below top edge to give space to rotate
    doMultipleMoves(piece, 5, 4, 1)
    piece.rotate()
    verifyBoardSparse("Ell rotate 90--obstructed by right wall", 
                             [(3,8),(3,9),(4,9),(5,9)], board)
    # Test opposite orientation with left wall
    # Move piece away from wall to give room to rotate
    doMultipleMoves(piece, -5, 0, 0)
    doMultipleMoves(piece, -4, 0, 2)
    piece.rotate()
    verifyBoardSparse("Ell rotate 270--obstructed by left wall", 
                             [(3,0),(4,0),(5,0),(5,1)], board)
    print

def moveLeftWithLandscapeEllTest():
    printTestName()
    board = PlayingBoard()
    setCellsOfBoard(landscape1, board)
    piece = Ell(board)
    doMultipleMoves(piece, -2, 10, 0)
    piece.moveLeft()
    verifyBoardWithLandscape("Ell left into landscape--partially obstructed", 
                             [(10,1),(10,2),(10,3),(11,1)], board, landscape1)
    doMultipleMoves(piece, -1, 3, 3)
    piece.moveLeft()
    verifyBoardWithLandscape("Ell left into landscape--fully obstructed", 
                             [(12,1),(13,1),(14,1),(14,2)], board, landscape1)
    print

def moveRightWithLandscapeEllTest():
    printTestName()
    board = PlayingBoard()
    setCellsOfBoard(landscape1, board)
    piece = Ell(board)
    doMultipleMoves(piece, 3, 10, 3)
    piece.moveRight()
    verifyBoardWithLandscape("Ell right into landscape--partially obstructed", 
                             [(9,7),(10,7),(11,7),(11,8)], board, landscape1)
    doMultipleMoves(piece, 1, 3, 2)
    piece.moveRight()
    verifyBoardWithLandscape("Ell right into landscape--fully obstructed", 
                             [(12,8),(13,8),(14,8),(12,7)], board, landscape1)
    print

def moveDownWithLandscapeEllTest():
    printTestName()
    board = PlayingBoard()
    setCellsOfBoard(landscape1, board)
    piece = Ell(board)
    doMultipleMoves(piece, 4, 10, 0)
    verifyFalse("Ell down into landscape--partially obstructed, return value", 
                  piece.moveDown())
    verifyBoardWithLandscape("Ell down into landscape--partially obstructed", 
                             [(10,7),(10,8),(10,9),(11,7)], board, landscape1)
    
    doMultipleMoves(piece, -4, 0, 1)
    doMultipleMoves(piece, -3, 1, 0)
    
    verifyFalse("Ell down into landscape--partially obstructed, return value", 
                  piece.moveDown())
    verifyBoardWithLandscape("Ell down into landscape--partially obstructed", 
                             [(10,1),(11,1),(12,1),(10,0)], board, landscape1)
    
    # Restart
    board = PlayingBoard()
    setCellsOfBoard(landscape2, board)
    piece = Ell(board)
    doMultipleMoves(piece, 0, 3, 1) # Lower into open space and rotate
    doMultipleMoves(piece, 0, 12, 0) # Lower into "canyon"
    verifyFalse("Ell down into landscape--fully obstructed, return value", 
                  piece.moveDown())
    verifyBoardWithLandscape("Ell down into landscape--fully obstructed", 
                             [(14, 4),(15, 4),(16, 4),(14,3)], board, landscape2)
    print

def rotateWithLandscapeEllTest():
    printTestName()
    board = PlayingBoard()
    setCellsOfBoard(landscape1, board)
    piece = Ell(board)
    # Need to split into 2 separate moves, else it gets caught the landscape
    doMultipleMoves(piece, 2, 10, 1)
    doMultipleMoves(piece, 0, 5, 0)
    piece.rotate()
    verifyBoardWithLandscape("Ell rotate in landscape--Barely clear", 
                             [(15,5),(15,6),(15,7),(14,7)], board, landscape1)
    piece.rotate()
    verifyBoardWithLandscape("Ell rotate in landscape--obstructed", 
                             [(15,5),(15,6),(15,7),(14,7)], board, landscape1)
    print

def ellTests():
    """Runs the tests."""
    initialFailureCount = getCountOfFailedTests()
    printTestSetName()
    newPieceTest(Ell(PlayingBoard()))
    print
    
    moveLeftEllTest()
    moveRightEllTest()
    moveDownEllTest()
    dropEllTest()
    rotateEllTest()
    rotateIntoWallEllTest()
    
    if getCountOfFailedTests() > initialFailureCount:
        announceAborting("ELL")
    else:
        moveLeftWithLandscapeEllTest()
        moveRightWithLandscapeEllTest()
        moveDownWithLandscapeEllTest()
        rotateWithLandscapeEllTest()
    
if __name__ == '__main__':
    ellTests()