# Tasks:
#  - Implement method stubs, creating helper methods and fields as needed.
#  - Do not change the test code at the end of the module.

from tetrisTestUtilities import *
from PlayingBoard import *

class Bar:
    """This is an implementation of:
       BBBB"""

    def __init__(self, board):
        """Constructs a new Bar piece on the given board."""
        # TODO: implement constructor for Bar
        
    def moveLeft(self):
        """ Moves the piece left if possible; otherwise leaves it unchanged."""
        # TODO: implement moveLeft for Bar
    
    def moveRight(self):
        """ Moves the piece right if possible; otherwise leaves it unchanged."""
        # TODO: implement moveRight for Bar

    def moveDown(self):
        """ Moves the piece down one row if possible, returning True in that case;
        otherwise leaves it unchanged and returns false."""
        # TODO: implement moveDown for Bar

    def drop(self):
        """ Moves the piece down as far as possible."""
        # TODO: implement drop for Bar

    def rotate(self):
        """ Rotates the piece clockwise if possible; otherwise leaves it unchanged."""
        # TODO: implement rotate for Bar


#-----------------------------------------------------------------------------
# BAR TESTS -- DO NOT CHANGE
#-----------------------------------------------------------------------------

def moveLeftBarTest():
    printTestName()
    board = PlayingBoard()
    piece = Bar(board)
    verifyBoardSparse("Initial Bar board", 
                      [(0,3),(0,4),(0,5),(0,6)], board)
    piece.moveLeft()
    verifyBoardSparse("Bar board after one moveLeft", 
                      [(0,2),(0,3),(0,4),(0,5)], board)
    doMultipleMoves(piece, -2, 0, 0)
    verifyBoardSparse("Bar board after moving to left edge", 
                      [(0,0),(0,1),(0,2),(0,3)], board)
    piece.moveLeft()
    verifyBoardSparse("Bar board after trying to move left again", 
                      [(0,0),(0,1),(0,2),(0,3)], board)
    print

def moveRightBarTest():
    printTestName()
    board = PlayingBoard()
    piece = Bar(board)
    piece.moveRight()
    verifyBoardSparse("Bar board after one moveRight", 
                      [(0,4),(0,5),(0,6),(0,7)], board)
    doMultipleMoves(piece, 3, 0, 0)
    verifyBoardSparse("Bar board after moving to right edge", 
                      [(0,6),(0,7),(0,8),(0,9)], board)
    piece.moveRight()
    verifyBoardSparse("Bar board after trying to move right again", 
                      [(0,6),(0,7),(0,8),(0,9)], board)
    print
    
def moveDownBarTest():
    printTestName()
    board = PlayingBoard()
    piece = Bar(board)
    verifyTrue("Bar initial moveDown return value", piece.moveDown())
    verifyBoardSparse("Bar board after one moveDown", 
                      [(1,3),(1,4),(1,5),(1,6)], board)
    doMultipleMoves(piece, 0, 15, 0)
    verifyBoardSparse("Bar board after moving one space from bottom edge", 
                      [(16,3),(16,4),(16,5),(16,6)], board)

    verifyTrue("Bar next-to-last moveDown return value", piece.moveDown())
    verifyBoardSparse("Bar board after trying to move down again", 
                      [(17,3),(17,4),(17,5),(17,6)], board)

    verifyFalse("Bar last moveDown return value", piece.moveDown())
    verifyBoardSparse("Bar board after trying to move down again", 
                      [(17,3),(17,4),(17,5),(17,6)], board)
    print

def dropBarTest():
    printTestName()
    board = PlayingBoard()
    piece = Bar(board)
    rotateAndDropHelper(piece, board, 0, [(17,3),(17,4),(17,5),(17,6)])
    
    board = PlayingBoard()
    piece = Bar(board)
    rotateAndDropHelper(piece, board, 1, [(14,4),(15,4),(16,4),(17,4)])
    
    board = PlayingBoard()
    piece = Bar(board)
    rotateAndDropHelper(piece, board, 2, [(17,2),(17,3),(17,4),(17,5)])

    board = PlayingBoard()
    piece = Bar(board)
    rotateAndDropHelper(piece, board, 3, [(14,4),(15,4),(16,4),(17,4)])

    board = PlayingBoard()
    piece = Bar(board)
    rotateAndDropHelper(piece, board, 4, [(17,3),(17,4),(17,5),(17,6)])
    print
    

def rotateBarTest():
    printTestName()
    board = PlayingBoard()
    piece = Bar(board)
    # Move piece below top edge to give space to rotate
    doMultipleMoves(piece, 0, 2, 0)
    piece.rotate()
    verifyBoardSparse("Bar board after one rotation", 
                      [(1,4),(2,4),(3,4),(4,4)], board)
    piece.rotate()
    verifyBoardSparse("Bar board after two rotations", 
                      [(2,2),(2,3),(2,4),(2,5)], board)
    piece.rotate()
    verifyBoardSparse("Bar board after three rotations", 
                      [(0,4),(1,4),(2,4),(3,4)], board)
    piece.rotate()
    verifyBoardSparse("Bar board after four rotations", 
                      [(2,3),(2,4),(2,5),(2,6)], board)
    print

def rotateIntoWallBarTest():
    printTestName()
    board = PlayingBoard()
    piece = Bar(board)
    # Move piece below top edge to give space to rotate
    doMultipleMoves(piece, 5, 4, 1)
    piece.rotate()
    verifyBoardSparse("Bar rotate 90--obstructed by right wall", 
                             [(3,9),(4,9),(5,9),(6,9)], board)
    # Test other orientation
    # Move piece away from wall to give room to rotate
    doMultipleMoves(piece, -5, 0, 0)
    doMultipleMoves(piece, 5, 0, 2)
    piece.rotate()
    verifyBoardSparse("Bar rotate 270--obstructed by right wall", 
                             [(2,9),(3,9),(4,9),(5,9)], board)
    # Test left wall
    doMultipleMoves(piece, -9, 0, 0)
    piece.rotate()
    verifyBoardSparse("Bar rotate 270--obstructed by left wall", 
                             [(2,0),(3,0),(4,0),(5,0)], board)
    # Test other orientation on left wall
    doMultipleMoves(piece, 4, 0, 0)
    doMultipleMoves(piece, -4, 0, 2)
    piece.rotate()
    verifyBoardSparse("Bar rotate 270--obstructed by right wall", 
                             [(3,0),(4,0),(5,0),(6,0)], board)
    print

def moveLeftWithLandscapeBarTest():
    printTestName()
    board = PlayingBoard()
    setCellsOfBoard(landscape1, board)
    piece = Bar(board)
    doMultipleMoves(piece, -2, 10, 1)
    piece.moveLeft()
    verifyBoardWithLandscape("Bar left into landscape--partially obstructed", 
                             [(9,1),(10,1),(11,1),(12,1)], board, landscape1)
    doMultipleMoves(piece, 0, 4, 0)
    piece.moveLeft()
    verifyBoardWithLandscape("Bar left into landscape--fully obstructed", 
                             [(13,1),(14,1),(15,1),(16,1)], board, landscape1)
    print

def moveRightWithLandscapeBarTest():
    printTestName()
    board = PlayingBoard()
    setCellsOfBoard(landscape1, board)
    piece = Bar(board)
    doMultipleMoves(piece, 4, 10, 1)
    piece.moveRight()
    verifyBoardWithLandscape("Bar right into landscape--partially obstructed", 
                             [(9,8),(10,8),(11,8),(12,8)], board, landscape1)
    doMultipleMoves(piece, 0, 2, 0)
    piece.moveRight()
    verifyBoardWithLandscape("Bar right into landscape--fully obstructed", 
                             [(11,8),(12,8),(13,8),(14,8)], board, landscape1)
    print

def moveDownWithLandscapeBarTest():
    printTestName()
    board = PlayingBoard()
    setCellsOfBoard(landscape1, board)
    piece = Bar(board)
    doMultipleMoves(piece, 3, 10, 0)
    verifyFalse("Bar down into landscape--partially obstructed, return value", 
                  piece.moveDown())
    verifyBoardWithLandscape("Bar down into landscape--partially obstructed", 
                             [(10,6),(10,7),(10,8),(10,9)], board, landscape1)
    # Need new everything, since piece bottomed out above
    board = PlayingBoard()
    setCellsOfBoard(landscape1, board)
    piece = Bar(board)
    doMultipleMoves(piece, 0, 3, 3) # Lower into open space and rotate
    doMultipleMoves(piece, 0, 12, 0) # Lower into "canyon"
    verifyFalse("Bar down into landscape--fully obstructed, return value", 
                  piece.moveDown())
    verifyBoardWithLandscape("Bar down into landscape--fully obstructed", 
                             [(13, 4),(14, 4),(15, 4),(16, 4)], board, landscape1)
    print

def rotateWithLandscapeBarTest():
    printTestName()
    board = PlayingBoard()
    setCellsOfBoard(landscape1, board)
    piece = Bar(board)
    doMultipleMoves(piece, -2, 11, 0)
    piece.rotate()
    verifyBoardWithLandscape("Bar rotate in landscape--barely clear", 
                             [(10,2),(11,2),(12,2),(13,2)], board, landscape1)
    piece.rotate()
    verifyBoardWithLandscape("Bar rotate in landscape--obstructed", 
                             [(10,2),(11,2),(12,2),(13,2)], board, landscape1)
    print

def barTests():
    """Runs the tests."""
    initialFailureCount = getCountOfFailedTests()
    printTestSetName()
    newPieceTest(Bar(PlayingBoard()))
    print
    
    moveLeftBarTest()
    moveRightBarTest()
    moveDownBarTest()
    dropBarTest()
    rotateBarTest()
    rotateIntoWallBarTest()
    
    if getCountOfFailedTests() > initialFailureCount:
        announceAborting("BAR")
    else:
        moveLeftWithLandscapeBarTest()
        moveRightWithLandscapeBarTest()
        moveDownWithLandscapeBarTest()
        rotateWithLandscapeBarTest()

if __name__ == '__main__':
    barTests()