;--- file 4-reverse-k-data-structure.ss -------------------
;--- implement the continuations ADT as data-structures ---
;--- use the same definitions of reverse-k and append-k ---
;--- as in 3-reverse-k.ss ---------------------------------

(load "chez-init.ss")
(define any? (lambda (x) #t))

(define-datatype continuation continuation?
  [append-kk
   (k continuation?)
   (a any?)]
  [init-k]
  [rev1-k
   (k continuation?)
   (L any?)]
  [rev2-k
   (reversed-cdr (list-of any?))
   (k continuation?)])

(define reverse*-k
  (lambda (L k)
    (if (null? L)
        (apply-k k '())
        (reverse*-k (cdr L)
                    (rev1-k k L)))))

(define testk
  (lambda () 
    (reverse*-k '(1 ((2 3) () (((4)))))
                (init-k))))

(define append-k
  (lambda (a b k)
    (if (null? a)
        (apply-k k b)
        (append-k (cdr a)
                  b
                  (append-kk k a)))))

(define apply-k
  (lambda (k v)
    (cases  continuation k
      [init-k ()
           (printf "answer ~s~n" v)]
      [append-kk (k a)
        (apply-k k
		 (cons (car a) v))]
      [rev1-k (k L)
        (if (pair? (car L))
            (reverse*-k (car L)
                        (rev2-k v k))
            (append-k v
                      (list (car L))
                      k))]
      [rev2-k (reversed-cdr k)
              (append-k
               reversed-cdr
               (list v)
               k)])))

(define trace-all
  (lambda ()
    (trace reverse*-k append-k apply-k)))