<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <title>Adventure Recommender</title>
    <link href="adventure.css" type="text/css" rel="stylesheet" />
  </head>

  <body>
  	<div class="logo">
    	<h1><img src="world.jpg" alt="world" /> Adventure Recommender</h1>
    </div>

    <?php
    # If the user has filled out the form, show the results.
    if (isset($_GET["economy"])) {
    	?>
		<p>
			Thanks for your submission!
		</p>

		<h2>
			Your preferences for your next adventure were to go to a country...
		</h2>

		<p>
			...in the following continents:
		</p>

		<ul>
		  <?php
			foreach ($_GET["continents"] as $param => $value) {
			  ?>
			  <li><?= $value ?></li>
			  <?php
			}
		  ?>
		</ul>

		<p>
			...where they speak the following languages:
		</p>

		<ul>
		  <?php
			foreach ($_GET["languages"] as $param => $value) {
			  ?>
			  <li><?= $value ?></li>
			  <?php
			}
		  ?>
		</ul>

		<p>
			...and has a <em><?= $_GET["economy"] ?></em> economy.
		</p>

		<h2>
			Countries that fit your preferences for your next adventure are:
		</h2>

		<?php
		print_countries();

	# otherwise, give the user the form to fill out
    } else {
    	?>

    	<p>
			Welcome to the Adventure Recommender -- the web site for discriminating
			traveller needing ideas!  Choose the demographics of a place you'd like
			to visit and we'll recommend countries for you to adventure to!
    	</p>

		<form action="adventure_recommender_v2.php" method="get">
			<div>
				<h2>Which continents do you prefer to travel to?</h2>

				<select name="continents[]" size="4" multiple="">
					<option value="Anywhere" selected="selected">Anywhere</option>
					<?php print_continent_options(); ?>
				</select>
			</div>

			<div>
			<h2>Which language(s) do prefer to be spoken?</h2>

				<select name="languages[]" size="12" multiple="">
					<option value="Any Language" selected="selected">Any Language</option>
					<?php print_language_options(); ?>
				</select>
			</div>

			<div>
				<h2>Do you prefer a developed or undeveloped country?</h2>

				<input type="radio" name="economy" value="developed" /> Developed
				<input type="radio" name="economy" value="developing" /> Developing
				<input type="radio" name="economy" value="any" checked="checked" /> Don't Mind
			</div>

			<div>
				<input type="submit" value="Submit" />
			</div>
		</form>

		<?php
    }
    ?>
  </body>
</html>

<?php
function print_continent_options() {
	$db = mysql_connect("webster.cs.washington.edu", "jkmiller", "9v3nTBWiL2eBC");
	mysql_select_db("world");

	$query = "SELECT DISTINCT continent
			  FROM Countries";
	$results = mysql_query($query);

	while ($row = mysql_fetch_array($results)) {
		$continent = $row["continent"];

		print("<option value=\"$continent\">$continent</option>");
	}

	mysql_free_result($results);
	mysql_close($db);
}

function print_language_options() {
	$db = mysql_connect("webster.cs.washington.edu", "jkmiller", "9v3nTBWiL2eBC");
	mysql_select_db("world");

	$query = "SELECT DISTINCT language
			  FROM CountriesLanguages
			  WHERE official = 'T'
				AND percentage > 85
			  ORDER BY language";
	$results = mysql_query($query);

	while ($row = mysql_fetch_array($results)) {
		$language = $row["language"];

		print("<option value=\"$language\">$language</option>");
	}

	mysql_free_result($results);
	mysql_close($db);
}

function print_countries() {
	$continents_selected = $_GET["continents"];
	$languages_selected = $_GET["languages"];

	$continent_clause = "c.continent IN (";
	$language_clause = "cl.language IN (";
	$economy_clause = "";

	for ($i = 0; $i < count($continents_selected); $i++) {
		if (strcmp($continents_selected[$i], "Anywhere") == 0) {
			$continent_clause = "";
			break;
		}

		$continent_clause = $continent_clause . "'$continents_selected[$i]'";

		if ($i < count($continents_selected) - 1) {
			$continent_clause = $continent_clause . ", ";
		}
	}

	for ($i = 0; $i < count($languages_selected); $i++) {
		if (strcmp($languages_selected[$i], "Any Language") == 0) {
			$language_clause = "";
			break;
		}

		$language_clause = $language_clause . "'$languages_selected[$i]'";


		if ($i < count($languages_selected) - 1) {
			$language_clause = $language_clause . ", ";
		}
	}

	if (strcmp($_GET["economy"], "developed") == 0) {
		$economy_clause = "AND (((c.gnp * 1000000) / c.population) >= 10000 AND c.life_expectancy >= 70)";
	} elseif (strcmp($_GET["economy"], "developing") == 0) {
		$economy_clause = "AND (((c.gnp * 1000000) / c.population) < 10000 OR c.life_expectancy < 70)";
	}

	$query = "SELECT DISTINCT c.name
			  FROM Countries c ";

	if (strlen($language_clause) > 0) {
		$language_clause = $language_clause . ") AND cl.official = 'T' AND cl.percentage > 85 ";

		$query = $query . "JOIN CountriesLanguages cl ON c.code = cl.country_code
						   WHERE " . $language_clause . $economy_clause;

		if (strlen($continent_clause) > 0) {
			$query = $query . " AND " . $continent_clause . ") " . $economy_clause;
		}

	} elseif (strlen($continent_clause) > 0) {
		$query = $query . "WHERE " . $continent_clause . ") " . $economy_clause;
	}

	// print($query);

	$db = mysql_connect("webster.cs.washington.edu", "jkmiller", "9v3nTBWiL2eBC");
	mysql_select_db("world");

	$results = mysql_query($query);

	if (mysql_num_rows($results) > 0) {
		print("<ul>");

		while ($row = mysql_fetch_array($results)) {
			$country = $row["name"];

			print("<li>$country</li>");
		}

		print("</ul>");
	} else {
		print("Sorry there were no countries matching your preferences.");
	}

	mysql_free_result($results);
	mysql_close($db);
}
?>
