<?php
# Point.php
# A Point object represents an integer (x, y) pair in the 2D plane.
class Point {
  private $x;
  private $y;
  
  # Creates a new Point at the given x/y position.
  public function __construct($x, $y) {
    $this->x = $x;
    $this->y = $y;
  }
  
  # Returns the distance between this point and the origin.
  public function distance() {
    return sqrt($this->x * $this->x + $this->y * $this->y);
  }
  
  # Shifts this Point's location by the given offsets.
  public function translate($dx, $dy) {
    $this->x += $dx;
    $this->y += $dy;
  }
  
  # Returns a String representation of this Point, such as "(3, -4)".
  public function __toString() {
    return "(" . $this->x . ", " . $this->y . ")";
  }
}
?>
