/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.BinaryNode;
import weiss.nonstandard.BinarySearchTree;
import weiss.nonstandard.DuplicateItemException;
import weiss.nonstandard.ItemNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySearchTreeWithRank<AnyType extends Comparable<? super AnyType>>
extends BinarySearchTree<AnyType> {
    public AnyType findKth(int k) {
        return (AnyType)((Comparable)this.findKth((int)k, this.root).element);
    }

    protected BinaryNode<AnyType> findKth(int k, BinaryNode<AnyType> t) {
        int leftSize;
        if (t == null) {
            throw new IllegalArgumentException();
        }
        int n = leftSize = t.left != null ? ((BinaryNodeWithSize)t.left).size : 0;
        if (k <= leftSize) {
            return this.findKth(k, t.left);
        }
        if (k == leftSize + 1) {
            return t;
        }
        return this.findKth(k - leftSize - 1, t.right);
    }

    @Override
    protected BinaryNode<AnyType> insert(AnyType x, BinaryNode<AnyType> tt) {
        BinaryNodeWithSize<AnyType> t = (BinaryNodeWithSize<AnyType>)tt;
        if (t == null) {
            t = new BinaryNodeWithSize<AnyType>(x);
        } else if (x.compareTo((Object)t.element) < 0) {
            t.left = this.insert(x, t.left);
        } else if (x.compareTo((Object)t.element) > 0) {
            t.right = this.insert(x, t.right);
        } else {
            throw new DuplicateItemException(x.toString());
        }
        ++t.size;
        return t;
    }

    @Override
    protected BinaryNode<AnyType> remove(AnyType x, BinaryNode<AnyType> tt) {
        BinaryNodeWithSize t = (BinaryNodeWithSize)tt;
        if (t == null) {
            throw new ItemNotFoundException(x.toString());
        }
        if (x.compareTo((Object)t.element) < 0) {
            t.left = this.remove(x, t.left);
        } else if (x.compareTo((Object)t.element) > 0) {
            t.right = this.remove(x, t.right);
        } else if (t.left != null && t.right != null) {
            t.element = this.findMin(t.right).element;
            t.right = this.removeMin(t.right);
        } else {
            return t.left != null ? t.left : t.right;
        }
        --t.size;
        return t;
    }

    @Override
    protected BinaryNode<AnyType> removeMin(BinaryNode<AnyType> tt) {
        BinaryNodeWithSize t = (BinaryNodeWithSize)tt;
        if (t == null) {
            throw new ItemNotFoundException();
        }
        if (t.left == null) {
            return t.right;
        }
        t.left = this.removeMin(t.left);
        --t.size;
        return t;
    }

    public static void main(String[] args) {
        BinarySearchTreeWithRank<Integer> t = new BinarySearchTreeWithRank<Integer>();
        int NUMS = 4000;
        int GAP = 37;
        System.out.println("Checking... (no more output means success)");
        int i = 37;
        while (i != 0) {
            t.insert(i);
            i = (i + 37) % 4000;
        }
        for (i = 1; i < 4000; i += 2) {
            t.remove(i);
        }
        if ((Integer)t.findMin() != 2 || (Integer)t.findMax() != 3998) {
            System.out.println("FindMin or FindMax error!");
        }
        for (i = 2; i < 4000; i += 2) {
            if (t.find(i) == i) continue;
            System.out.println("Find error1!");
        }
        for (i = 1; i < 4000; i += 2) {
            if (t.find(i) == null) continue;
            System.out.println("Find error2!");
        }
        for (i = 2; i < 4000; i += 2) {
            if ((Integer)t.findKth(i / 2) == i) continue;
            System.out.println("FindKth error!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinaryNodeWithSize<AnyType>
    extends BinaryNode<AnyType> {
        int size = 0;

        BinaryNodeWithSize(AnyType x) {
            super(x);
        }
    }
}

