/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.Stack;
import weiss.nonstandard.UnderflowException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayStack<AnyType>
implements Stack<AnyType> {
    private AnyType[] theArray = new Object[10];
    private int topOfStack = -1;
    private static final int DEFAULT_CAPACITY = 10;

    @Override
    public boolean isEmpty() {
        return this.topOfStack == -1;
    }

    @Override
    public void makeEmpty() {
        this.topOfStack = -1;
    }

    @Override
    public AnyType top() {
        if (this.isEmpty()) {
            throw new UnderflowException("ArrayStack top");
        }
        return this.theArray[this.topOfStack];
    }

    @Override
    public void pop() {
        if (this.isEmpty()) {
            throw new UnderflowException("ArrayStack pop");
        }
        --this.topOfStack;
    }

    @Override
    public AnyType topAndPop() {
        if (this.isEmpty()) {
            throw new UnderflowException("ArrayStack topAndPop");
        }
        return this.theArray[this.topOfStack--];
    }

    @Override
    public void push(AnyType x) {
        if (this.topOfStack + 1 == this.theArray.length) {
            this.doubleArray();
        }
        this.theArray[++this.topOfStack] = x;
    }

    private void doubleArray() {
        Object[] newArray = new Object[this.theArray.length * 2];
        for (int i = 0; i < this.theArray.length; ++i) {
            newArray[i] = this.theArray[i];
        }
        this.theArray = newArray;
    }
}

