/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import java.io.Serializable;
import weiss.util.AbstractCollection;
import weiss.util.Collection;
import weiss.util.Comparator;
import weiss.util.ConcurrentModificationException;
import weiss.util.Iterator;
import weiss.util.NoSuchElementException;
import weiss.util.SortedSet;
import weiss.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSet<AnyType>
extends AbstractCollection<AnyType>
implements SortedSet<AnyType> {
    private int modCount = 0;
    private int theSize = 0;
    private AANode<AnyType> root = null;
    private Comparator<? super AnyType> cmp;
    private AANode<AnyType> nullNode = new AANode<Object>(null, null, null);
    private AANode<AnyType> deletedNode;
    private AANode<AnyType> lastNode;

    public TreeSet() {
        this.nullNode.right = this.nullNode;
        this.nullNode.left = this.nullNode.right;
        this.nullNode.level = 0;
        this.root = this.nullNode;
        this.cmp = null;
    }

    public TreeSet(Comparator<? super AnyType> c) {
        this();
        this.cmp = c;
    }

    public TreeSet(SortedSet<AnyType> other) {
        this(other.comparator());
        super.copyFrom(other);
    }

    public TreeSet(Collection<? extends AnyType> other) {
        this();
        super.copyFrom(other);
    }

    @Override
    public Comparator<? super AnyType> comparator() {
        return this.cmp;
    }

    private void copyFrom(Collection<? extends AnyType> other) {
        this.clear();
        for (Object x : other) {
            this.add(x);
        }
    }

    @Override
    public int size() {
        return this.theSize;
    }

    @Override
    public AnyType first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        AANode<AnyType> ptr = this.root;
        while (ptr.left != this.nullNode) {
            ptr = ptr.left;
        }
        return ptr.element;
    }

    @Override
    public AnyType last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        AANode<AnyType> ptr = this.root;
        while (ptr.right != this.nullNode) {
            ptr = ptr.right;
        }
        return ptr.element;
    }

    @Override
    public AnyType getMatch(AnyType x) {
        AANode<AnyType> p = this.find(x);
        if (p == null) {
            return null;
        }
        return p.element;
    }

    private AANode<AnyType> find(AnyType x) {
        AANode<AnyType> current = this.root;
        this.nullNode.element = x;
        while (true) {
            int result;
            if ((result = this.compare(x, current.element)) < 0) {
                current = current.left;
                continue;
            }
            if (result <= 0) break;
            current = current.right;
        }
        if (current != this.nullNode) {
            return current;
        }
        return null;
    }

    private int compare(AnyType lhs, AnyType rhs) {
        if (this.cmp == null) {
            return ((Comparable)lhs).compareTo(rhs);
        }
        return this.cmp.compare(lhs, rhs);
    }

    @Override
    public boolean contains(Object x) {
        try {
            return this.getMatch(x) != null;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean add(AnyType x) {
        int oldSize = this.size();
        this.root = this.insert(x, this.root);
        return this.size() != oldSize;
    }

    private AANode<AnyType> insert(AnyType x, AANode<AnyType> t) {
        if (t == this.nullNode) {
            t = new AANode<AnyType>(x, this.nullNode, this.nullNode);
            ++this.modCount;
            ++this.theSize;
        } else {
            int result = this.compare(x, t.element);
            if (result < 0) {
                t.left = this.insert(x, t.left);
            } else if (result > 0) {
                t.right = this.insert(x, t.right);
            } else {
                return t;
            }
        }
        t = TreeSet.skew(t);
        t = TreeSet.split(t);
        return t;
    }

    @Override
    public boolean remove(Object x) {
        int oldSize = this.size();
        this.deletedNode = this.nullNode;
        this.root = this.remove(x, this.root);
        return this.size() != oldSize;
    }

    private AANode<AnyType> remove(AnyType x, AANode<AnyType> t) {
        if (t != this.nullNode) {
            this.lastNode = t;
            if (this.compare(x, t.element) < 0) {
                t.left = this.remove(x, t.left);
            } else {
                this.deletedNode = t;
                t.right = this.remove(x, t.right);
            }
            if (t == this.lastNode) {
                if (this.deletedNode == this.nullNode || this.compare(x, this.deletedNode.element) != 0) {
                    return t;
                }
                this.deletedNode.element = t.element;
                t = t.right;
                --this.theSize;
                ++this.modCount;
            } else if (t.left.level < t.level - 1 || t.right.level < t.level - 1) {
                if (t.right.level > --t.level) {
                    t.right.level = t.level;
                }
                t = TreeSet.skew(t);
                t.right = TreeSet.skew(t.right);
                t.right.right = TreeSet.skew(t.right.right);
                t = TreeSet.split(t);
                t.right = TreeSet.split(t.right);
            }
        }
        return t;
    }

    @Override
    public void clear() {
        this.theSize = 0;
        ++this.modCount;
        this.root = this.nullNode;
    }

    @Override
    public Iterator<AnyType> iterator() {
        return new TreeSetIterator();
    }

    private static <AnyType> AANode<AnyType> skew(AANode<AnyType> t) {
        if (t.left.level == t.level) {
            t = TreeSet.rotateWithLeftChild(t);
        }
        return t;
    }

    private static <AnyType> AANode<AnyType> split(AANode<AnyType> t) {
        if (t.right.right.level == t.level) {
            t = TreeSet.rotateWithRightChild(t);
            ++t.level;
        }
        return t;
    }

    private static <AnyType> AANode<AnyType> rotateWithLeftChild(AANode<AnyType> k2) {
        AANode k1 = k2.left;
        k2.left = k1.right;
        k1.right = k2;
        return k1;
    }

    private static <AnyType> AANode<AnyType> rotateWithRightChild(AANode<AnyType> k1) {
        AANode k2 = k1.right;
        k1.right = k2.left;
        k2.left = k1;
        return k2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AANode<AnyType>
    implements Serializable {
        public AnyType element;
        public AANode<AnyType> left;
        public AANode<AnyType> right;
        public int level;

        public AANode(AnyType theElement, AANode<AnyType> lt, AANode<AnyType> rt) {
            this.element = theElement;
            this.left = lt;
            this.right = rt;
            this.level = 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeSetIterator
    implements Iterator<AnyType> {
        private int expectedModCount;
        private int visited;
        private Stack<AANode<AnyType>> path;
        private AANode<AnyType> current;
        private AANode<AnyType> lastVisited;

        public TreeSetIterator() {
            this.expectedModCount = TreeSet.this.modCount;
            this.visited = 0;
            this.path = new Stack();
            this.current = null;
            this.lastVisited = null;
            if (TreeSet.this.isEmpty()) {
                return;
            }
            AANode p = null;
            p = TreeSet.this.root;
            while (p.left != TreeSet.this.nullNode) {
                this.path.push(p);
                p = p.left;
            }
            this.current = p;
        }

        @Override
        public boolean hasNext() {
            if (this.expectedModCount != TreeSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.visited < TreeSet.this.size();
        }

        @Override
        public AnyType next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object value = this.current.element;
            this.lastVisited = this.current;
            if (this.current.right != TreeSet.this.nullNode) {
                this.path.push(this.current);
                this.current = this.current.right;
                while (this.current.left != TreeSet.this.nullNode) {
                    this.path.push(this.current);
                    this.current = this.current.left;
                }
            } else {
                while (!this.path.isEmpty()) {
                    AANode parent = this.path.pop();
                    if (parent.left == this.current) {
                        this.current = parent;
                        break;
                    }
                    this.current = parent;
                }
            }
            ++this.visited;
            return value;
        }

        @Override
        public void remove() {
            if (this.expectedModCount != TreeSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastVisited == null) {
                throw new IllegalStateException();
            }
            Object valueToRemove = this.lastVisited.element;
            TreeSet.this.remove(valueToRemove);
            ++this.expectedModCount;
            --this.visited;
            this.lastVisited = null;
            if (!this.hasNext()) {
                return;
            }
            Object nextValue = this.current.element;
            this.path.clear();
            AANode p = TreeSet.this.root;
            while (true) {
                this.path.push(p);
                int result = TreeSet.this.compare(nextValue, p.element);
                if (result < 0) {
                    p = p.left;
                    continue;
                }
                if (result <= 0) break;
                p = p.right;
            }
            this.path.pop();
            this.current = p;
        }
    }
}

