/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.AbstractCollection;
import weiss.util.Collection;
import weiss.util.Comparator;
import weiss.util.Iterator;
import weiss.util.NoSuchElementException;
import weiss.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityQueue<AnyType>
extends AbstractCollection<AnyType>
implements Queue<AnyType> {
    private static final int DEFAULT_CAPACITY = 100;
    private int currentSize;
    private AnyType[] array;
    private Comparator<? super AnyType> cmp;

    public PriorityQueue() {
        this.currentSize = 0;
        this.cmp = null;
        this.array = new Object[101];
    }

    public PriorityQueue(Comparator<? super AnyType> c) {
        this.currentSize = 0;
        this.cmp = c;
        this.array = new Object[101];
    }

    public PriorityQueue(Collection<? extends AnyType> coll) {
        this.cmp = null;
        this.currentSize = coll.size();
        this.array = new Object[(this.currentSize + 2) * 11 / 10];
        int i = 1;
        for (Object item : coll) {
            this.array[i++] = item;
        }
        this.buildHeap();
    }

    private int compare(AnyType lhs, AnyType rhs) {
        if (this.cmp == null) {
            return ((Comparable)lhs).compareTo(rhs);
        }
        return this.cmp.compare(lhs, rhs);
    }

    @Override
    public boolean add(AnyType x) {
        if (this.currentSize + 1 == this.array.length) {
            this.doubleArray();
        }
        int hole = ++this.currentSize;
        this.array[0] = x;
        while (this.compare(x, this.array[hole / 2]) < 0) {
            this.array[hole] = this.array[hole / 2];
            hole /= 2;
        }
        this.array[hole] = x;
        return true;
    }

    @Override
    public int size() {
        return this.currentSize;
    }

    @Override
    public void clear() {
        this.currentSize = 0;
    }

    @Override
    public Iterator<AnyType> iterator() {
        return new Iterator<AnyType>(){
            int current = 0;

            @Override
            public boolean hasNext() {
                return this.current != PriorityQueue.this.size();
            }

            @Override
            public AnyType next() {
                if (this.hasNext()) {
                    return PriorityQueue.this.array[++this.current];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public AnyType element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.array[1];
    }

    @Override
    public AnyType remove() {
        AnyType minItem = this.element();
        this.array[1] = this.array[this.currentSize--];
        this.percolateDown(1);
        return minItem;
    }

    private void buildHeap() {
        for (int i = this.currentSize / 2; i > 0; --i) {
            this.percolateDown(i);
        }
    }

    private void percolateDown(int hole) {
        AnyType tmp = this.array[hole];
        while (hole * 2 <= this.currentSize) {
            int child = hole * 2;
            if (child != this.currentSize && this.compare(this.array[child + 1], this.array[child]) < 0) {
                ++child;
            }
            if (this.compare(this.array[child], tmp) >= 0) break;
            this.array[hole] = this.array[child];
            hole = child;
        }
        this.array[hole] = tmp;
    }

    private void doubleArray() {
        Object[] newArray = new Object[this.array.length * 2];
        for (int i = 0; i < this.array.length; ++i) {
            newArray[i] = this.array[i];
        }
        this.array = newArray;
    }
}

