/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.Collection;
import weiss.util.Comparator;
import weiss.util.Iterator;
import weiss.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collections {
    private Collections() {
    }

    public static <AnyType> AnyType max(Collection<? extends AnyType> coll) {
        return Collections.max(coll, new DefaultComparator());
    }

    public static <AnyType> AnyType max(Collection<? extends AnyType> coll, Comparator<? super AnyType> cmp) {
        if (coll.size() == 0) {
            throw new NoSuchElementException();
        }
        Iterator<AnyType> itr = coll.iterator();
        AnyType maxValue = itr.next();
        while (itr.hasNext()) {
            AnyType current = itr.next();
            if (cmp.compare(current, maxValue) <= 0) continue;
            maxValue = current;
        }
        return maxValue;
    }

    public static <AnyType> Comparator<AnyType> reverseOrder() {
        return new ReverseComparator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultComparator<AnyType extends Comparable<? super AnyType>>
    implements Comparator<AnyType> {
        DefaultComparator() {
        }

        @Override
        public int compare(AnyType lhs, AnyType rhs) {
            return lhs.compareTo(rhs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseComparator<AnyType>
    implements Comparator<AnyType> {
        private ReverseComparator() {
        }

        @Override
        public int compare(AnyType lhs, AnyType rhs) {
            return -((Comparable)lhs).compareTo(rhs);
        }
    }
}

