/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.Collections;
import weiss.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    private Arrays() {
    }

    public static <AnyType extends Comparable<? super AnyType>> int binarySearch(AnyType[] arr, AnyType x) {
        return Arrays.binarySearch(arr, x, new Collections.DefaultComparator());
    }

    public static <AnyType> int binarySearch(AnyType[] arr, AnyType x, Comparator<? super AnyType> cmp) {
        int low = 0;
        int mid = 0;
        int high = arr.length;
        while (low < high) {
            mid = (low + high) / 2;
            if (cmp.compare(x, arr[mid]) > 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        if (low == arr.length || cmp.compare(x, arr[low]) != 0) {
            return -(low + 1);
        }
        return low;
    }
}

