/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.DuplicateItemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedBlackTree<AnyType extends Comparable<? super AnyType>> {
    private RedBlackNode<AnyType> header;
    private RedBlackNode<AnyType> nullNode = new RedBlackNode<Object>(null);
    private static final int BLACK = 1;
    private static final int RED = 0;
    private RedBlackNode<AnyType> current;
    private RedBlackNode<AnyType> parent;
    private RedBlackNode<AnyType> grand;
    private RedBlackNode<AnyType> great;

    public RedBlackTree() {
        this.nullNode.right = this.nullNode;
        this.nullNode.left = this.nullNode.right;
        this.header = new RedBlackNode<Object>(null);
        this.header.right = this.nullNode;
        this.header.left = this.header.right;
    }

    private final int compare(AnyType item, RedBlackNode<AnyType> t) {
        if (t == this.header) {
            return 1;
        }
        return item.compareTo(t.element);
    }

    public void insert(AnyType item) {
        this.grand = this.header;
        this.parent = this.grand;
        this.current = this.grand;
        this.nullNode.element = item;
        while (this.compare(item, this.current) != 0) {
            this.great = this.grand;
            this.grand = this.parent;
            this.parent = this.current;
            RedBlackNode redBlackNode = this.current = this.compare(item, this.current) < 0 ? this.current.left : this.current.right;
            if (this.current.left.color != 0 || this.current.right.color != 0) continue;
            this.handleReorient(item);
        }
        if (this.current != this.nullNode) {
            throw new DuplicateItemException(item.toString());
        }
        this.current = new RedBlackNode<AnyType>(item, this.nullNode, this.nullNode);
        if (this.compare(item, this.parent) < 0) {
            this.parent.left = this.current;
        } else {
            this.parent.right = this.current;
        }
        this.handleReorient(item);
    }

    public void remove(AnyType x) {
        throw new UnsupportedOperationException();
    }

    public AnyType findMin() {
        if (this.isEmpty()) {
            return null;
        }
        RedBlackNode itr = this.header.right;
        while (itr.left != this.nullNode) {
            itr = itr.left;
        }
        return (AnyType)((Comparable)itr.element);
    }

    public AnyType findMax() {
        if (this.isEmpty()) {
            return null;
        }
        RedBlackNode itr = this.header.right;
        while (itr.right != this.nullNode) {
            itr = itr.right;
        }
        return (AnyType)((Comparable)itr.element);
    }

    public AnyType find(AnyType x) {
        this.nullNode.element = x;
        this.current = this.header.right;
        while (true) {
            if (x.compareTo(this.current.element) < 0) {
                this.current = this.current.left;
                continue;
            }
            if (x.compareTo(this.current.element) <= 0) break;
            this.current = this.current.right;
        }
        if (this.current != this.nullNode) {
            return (AnyType)((Comparable)this.current.element);
        }
        return null;
    }

    public void makeEmpty() {
        this.header.right = this.nullNode;
    }

    public void printTree() {
        this.printTree(this.header.right);
    }

    private void printTree(RedBlackNode<AnyType> t) {
        if (t != this.nullNode) {
            this.printTree(t.left);
            System.out.println(t.element);
            this.printTree(t.right);
        }
    }

    public boolean isEmpty() {
        return this.header.right == this.nullNode;
    }

    private void handleReorient(AnyType item) {
        this.current.color = 0;
        this.current.left.color = 1;
        this.current.right.color = 1;
        if (this.parent.color == 0) {
            this.grand.color = 0;
            if (this.compare(item, this.grand) < 0 != this.compare(item, this.parent) < 0) {
                this.parent = this.rotate(item, this.grand);
            }
            this.current = this.rotate(item, this.great);
            this.current.color = 1;
        }
        this.header.right.color = 1;
    }

    private RedBlackNode<AnyType> rotate(AnyType item, RedBlackNode<AnyType> parent) {
        if (this.compare(item, parent) < 0) {
            parent.left = this.compare(item, parent.left) < 0 ? RedBlackTree.rotateWithLeftChild(parent.left) : RedBlackTree.rotateWithRightChild(parent.left);
            return parent.left;
        }
        parent.right = this.compare(item, parent.right) < 0 ? RedBlackTree.rotateWithLeftChild(parent.right) : RedBlackTree.rotateWithRightChild(parent.right);
        return parent.right;
    }

    private static <AnyType> RedBlackNode<AnyType> rotateWithLeftChild(RedBlackNode<AnyType> k2) {
        RedBlackNode k1 = k2.left;
        k2.left = k1.right;
        k1.right = k2;
        return k1;
    }

    private static <AnyType> RedBlackNode<AnyType> rotateWithRightChild(RedBlackNode<AnyType> k1) {
        RedBlackNode k2 = k1.right;
        k1.right = k2.left;
        k2.left = k1;
        return k2;
    }

    public static void main(String[] args) {
        RedBlackTree<Integer> t = new RedBlackTree<Integer>();
        int NUMS = 400000;
        int GAP = 35461;
        System.out.println("Checking... (no more output means success)");
        int i = 35461;
        while (i != 0) {
            t.insert(i);
            i = (i + 35461) % 400000;
        }
        if ((Integer)t.findMin() != 1 || (Integer)t.findMax() != 399999) {
            System.out.println("FindMin or FindMax error!");
        }
        for (i = 1; i < 400000; ++i) {
            if (t.find(i) == i) continue;
            System.out.println("Find error1!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RedBlackNode<AnyType> {
        AnyType element;
        RedBlackNode<AnyType> left;
        RedBlackNode<AnyType> right;
        int color;

        RedBlackNode(AnyType theElement) {
            this(theElement, null, null);
        }

        RedBlackNode(AnyType theElement, RedBlackNode<AnyType> lt, RedBlackNode<AnyType> rt) {
            this.element = theElement;
            this.left = lt;
            this.right = rt;
            this.color = 1;
        }
    }
}

