/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import java.util.ArrayList;
import weiss.nonstandard.IllegalValueException;
import weiss.nonstandard.UnderflowException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairingHeap<AnyType extends Comparable<? super AnyType>> {
    private PairNode<AnyType> root = null;
    private int theSize = 0;
    private PairNode[] treeArray = new PairNode[5];

    public Position<AnyType> insert(AnyType x) {
        PairNode<AnyType> newNode = new PairNode<AnyType>(x);
        this.root = this.root == null ? newNode : this.compareAndLink(this.root, newNode);
        ++this.theSize;
        return newNode;
    }

    public AnyType findMin() {
        if (this.isEmpty()) {
            throw new UnderflowException("Pairing heap is empty");
        }
        return (AnyType)((Comparable)this.root.element);
    }

    public AnyType deleteMin() {
        if (this.isEmpty()) {
            throw new UnderflowException("Pairing heap is empty");
        }
        AnyType x = this.findMin();
        this.root.element = null;
        this.root = this.root.leftChild == null ? null : this.combineSiblings(this.root.leftChild);
        --this.theSize;
        return x;
    }

    public void decreaseKey(Position<AnyType> pos, AnyType newVal) {
        if (pos == null) {
            throw new IllegalArgumentException("null Position passed to decreaseKey");
        }
        PairNode p = (PairNode)pos;
        if (p.element == null) {
            throw new IllegalValueException("pos already deleted");
        }
        if (((Comparable)p.element).compareTo(newVal) < 0) {
            throw new IllegalValueException("newVal/oldval: " + newVal + " /" + p.element);
        }
        p.element = newVal;
        if (p != this.root) {
            if (p.nextSibling != null) {
                p.nextSibling.prev = p.prev;
            }
            if (p.prev.leftChild == p) {
                p.prev.leftChild = p.nextSibling;
            } else {
                p.prev.nextSibling = p.nextSibling;
            }
            p.nextSibling = null;
            this.root = this.compareAndLink(this.root, p);
        }
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public int size() {
        return this.theSize;
    }

    public void makeEmpty() {
        this.root = null;
        this.theSize = 0;
    }

    private PairNode<AnyType> compareAndLink(PairNode<AnyType> first, PairNode<AnyType> second) {
        if (second == null) {
            return first;
        }
        if (((Comparable)second.element).compareTo(first.element) < 0) {
            second.prev = first.prev;
            first.prev = second;
            first.nextSibling = second.leftChild;
            if (first.nextSibling != null) {
                first.nextSibling.prev = first;
            }
            second.leftChild = first;
            return second;
        }
        second.prev = first;
        first.nextSibling = second.nextSibling;
        if (first.nextSibling != null) {
            first.nextSibling.prev = first;
        }
        second.nextSibling = first.leftChild;
        if (second.nextSibling != null) {
            second.nextSibling.prev = second;
        }
        first.leftChild = second;
        return first;
    }

    private PairNode[] doubleIfFull(PairNode[] array, int index) {
        if (index == array.length) {
            PairNode[] oldArray = array;
            array = new PairNode[index * 2];
            for (int i = 0; i < index; ++i) {
                array[i] = oldArray[i];
            }
        }
        return array;
    }

    private PairNode<AnyType> combineSiblings(PairNode<AnyType> firstSibling) {
        if (firstSibling.nextSibling == null) {
            return firstSibling;
        }
        int numSiblings = 0;
        while (firstSibling != null) {
            this.treeArray = this.doubleIfFull(this.treeArray, numSiblings);
            this.treeArray[numSiblings] = firstSibling;
            firstSibling.prev.nextSibling = null;
            firstSibling = firstSibling.nextSibling;
            ++numSiblings;
        }
        this.treeArray = this.doubleIfFull(this.treeArray, numSiblings);
        this.treeArray[numSiblings] = null;
        int i = 0;
        while (i + 1 < numSiblings) {
            this.treeArray[i] = this.compareAndLink(this.treeArray[i], this.treeArray[i + 1]);
            i += 2;
        }
        int j = i - 2;
        if (j == numSiblings - 3) {
            this.treeArray[j] = this.compareAndLink(this.treeArray[j], this.treeArray[j + 2]);
        }
        while (j >= 2) {
            this.treeArray[j - 2] = this.compareAndLink(this.treeArray[j - 2], this.treeArray[j]);
            j -= 2;
        }
        return this.treeArray[0];
    }

    public static void main(String[] args) {
        PairingHeap<Integer> h = new PairingHeap<Integer>();
        int numItems = 10000;
        int i = 37;
        System.out.println("Checking; no bad output is good");
        i = 37;
        while (i != 0) {
            h.insert(i);
            i = (i + 37) % numItems;
        }
        for (i = 1; i < numItems; ++i) {
            if ((Integer)h.deleteMin() == i) continue;
            System.out.println("Oops! " + i);
        }
        ArrayList<Position<Integer>> p = new ArrayList<Position<Integer>>();
        for (i = 0; i < numItems; ++i) {
            p.add(null);
        }
        int j = numItems / 2;
        for (i = 0; i < numItems; ++i) {
            p.set(j, h.insert(j + numItems));
            j = (j + 71) % numItems;
        }
        j = numItems / 2;
        for (i = 0; i < numItems; ++i) {
            h.decreaseKey((Position)p.get(j), (Integer)((Position)p.get(j)).getValue() - numItems);
            j = (j + 53) % numItems;
        }
        i = -1;
        while (!h.isEmpty()) {
            if ((Integer)h.deleteMin() == ++i) continue;
            System.out.println("Oops! " + i + " ");
        }
        System.out.println("Check completed");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PairNode<AnyType>
    implements Position<AnyType> {
        public AnyType element;
        public PairNode<AnyType> leftChild;
        public PairNode<AnyType> nextSibling;
        public PairNode<AnyType> prev;

        public PairNode(AnyType theElement) {
            this.element = theElement;
            this.leftChild = null;
            this.nextSibling = null;
            this.prev = null;
        }

        @Override
        public AnyType getValue() {
            return this.element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Position<AnyType> {
        public AnyType getValue();
    }
}

