/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.BinaryNode;
import weiss.nonstandard.DuplicateItemException;
import weiss.nonstandard.ItemNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySearchTree<AnyType extends Comparable<? super AnyType>> {
    protected BinaryNode<AnyType> root = null;

    public void insert(AnyType x) {
        this.root = this.insert(x, this.root);
    }

    public void remove(AnyType x) {
        this.root = this.remove(x, this.root);
    }

    public void removeMin() {
        this.root = this.removeMin(this.root);
    }

    public AnyType findMin() {
        return this.elementAt(this.findMin(this.root));
    }

    public AnyType findMax() {
        return this.elementAt(this.findMax(this.root));
    }

    public AnyType find(AnyType x) {
        return this.elementAt(this.find(x, this.root));
    }

    public void makeEmpty() {
        this.root = null;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    private AnyType elementAt(BinaryNode<AnyType> t) {
        return (AnyType)(t == null ? null : (Comparable)t.element);
    }

    protected BinaryNode<AnyType> insert(AnyType x, BinaryNode<AnyType> t) {
        if (t == null) {
            t = new BinaryNode<AnyType>(x);
        } else if (x.compareTo(t.element) < 0) {
            t.left = this.insert(x, t.left);
        } else if (x.compareTo(t.element) > 0) {
            t.right = this.insert(x, t.right);
        } else {
            throw new DuplicateItemException(x.toString());
        }
        return t;
    }

    protected BinaryNode<AnyType> remove(AnyType x, BinaryNode<AnyType> t) {
        if (t == null) {
            throw new ItemNotFoundException(x.toString());
        }
        if (x.compareTo(t.element) < 0) {
            t.left = this.remove(x, t.left);
        } else if (x.compareTo(t.element) > 0) {
            t.right = this.remove(x, t.right);
        } else if (t.left != null && t.right != null) {
            t.element = this.findMin(t.right).element;
            t.right = this.removeMin(t.right);
        } else {
            t = t.left != null ? t.left : t.right;
        }
        return t;
    }

    protected BinaryNode<AnyType> removeMin(BinaryNode<AnyType> t) {
        if (t == null) {
            throw new ItemNotFoundException();
        }
        if (t.left != null) {
            t.left = this.removeMin(t.left);
            return t;
        }
        return t.right;
    }

    protected BinaryNode<AnyType> findMin(BinaryNode<AnyType> t) {
        if (t != null) {
            while (t.left != null) {
                t = t.left;
            }
        }
        return t;
    }

    private BinaryNode<AnyType> findMax(BinaryNode<AnyType> t) {
        if (t != null) {
            while (t.right != null) {
                t = t.right;
            }
        }
        return t;
    }

    private BinaryNode<AnyType> find(AnyType x, BinaryNode<AnyType> t) {
        while (t != null) {
            if (x.compareTo(t.element) < 0) {
                t = t.left;
                continue;
            }
            if (x.compareTo(t.element) > 0) {
                t = t.right;
                continue;
            }
            return t;
        }
        return null;
    }

    public static void main(String[] args) {
        BinarySearchTree<Integer> t = new BinarySearchTree<Integer>();
        int NUMS = 4000;
        int GAP = 37;
        System.out.println("Checking... (no more output means success)");
        int i = 37;
        while (i != 0) {
            t.insert(i);
            i = (i + 37) % 4000;
        }
        for (i = 1; i < 4000; i += 2) {
            t.remove(i);
        }
        if ((Integer)t.findMin() != 2 || (Integer)t.findMax() != 3998) {
            System.out.println("FindMin or FindMax error!");
        }
        for (i = 2; i < 4000; i += 2) {
            if (t.find(i) == i) continue;
            System.out.println("Find error1!");
        }
        for (i = 1; i < 4000; i += 2) {
            if (t.find(i) == null) continue;
            System.out.println("Find error2!");
        }
    }
}

