/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Random48 {
    private static final long A = 25214903917L;
    private static final long C = 11L;
    private static final long M = 0x1000000000000L;
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private long state;

    public Random48() {
        this(System.nanoTime());
    }

    public Random48(long initialValue) {
        this.state = initialValue & 0xFFFFFFFFFFFFL;
    }

    private int next(int bits) {
        if (bits <= 0 || bits > 32) {
            throw new IllegalArgumentException();
        }
        this.state = 25214903917L * this.state + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.state >>> 48 - bits);
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int high) {
        return (int)(Math.abs(this.nextLong()) % (long)high);
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    public int nextInt(int low, int high) {
        return this.nextInt(high - low + 1) + low;
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public int nextPoisson(double expectedValue) {
        double limit = -expectedValue;
        double product = Math.log(this.nextDouble());
        int count = 0;
        while (product > limit) {
            product += Math.log(this.nextDouble());
            ++count;
        }
        return count;
    }

    public double nextNegExp(double expectedValue) {
        return -expectedValue * Math.log(this.nextDouble());
    }

    private static final <AnyType> void swapReferences(AnyType[] a, int index1, int index2) {
        AnyType tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    public static final <AnyType> void permute(AnyType[] a) {
        Random r = new Random();
        for (int j = 1; j < a.length; ++j) {
            Random48.swapReferences(a, j, r.nextInt(0, j));
        }
    }

    public static void main(String[] args) {
        int i;
        Random48 r = new Random48();
        for (int i2 = 0; i2 < 20; ++i2) {
            System.out.println(r.nextInt());
        }
        int[] dist = new int[10000];
        int SAMPLES = 100000000;
        for (i = 0; i < 100000000; ++i) {
            int n = r.nextPoisson(2.0);
            dist[n] = dist[n] + 1;
        }
        for (i = 0; i < 10; ++i) {
            System.out.println(i + ": " + (double)dist[i] / 1.0E8);
        }
    }
}

