/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.AbstractCollection;
import weiss.util.Collection;
import weiss.util.ConcurrentModificationException;
import weiss.util.Iterator;
import weiss.util.List;
import weiss.util.ListIterator;
import weiss.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayList<AnyType>
extends AbstractCollection<AnyType>
implements List<AnyType> {
    private static final int DEFAULT_CAPACITY = 10;
    private static final int NOT_FOUND = -1;
    private AnyType[] theItems;
    private int theSize;
    private int modCount = 0;

    public ArrayList() {
        this.clear();
    }

    public ArrayList(Collection<? extends AnyType> other) {
        this.clear();
        for (Object obj : other) {
            this.add(obj);
        }
    }

    public ArrayList<AnyType> subList(int from, int to) {
        return new SubList(from, to);
    }

    @Override
    public int size() {
        return this.theSize;
    }

    @Override
    public AnyType get(int idx) {
        if (idx < 0 || idx >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + idx + "; size " + this.size());
        }
        return this.theItems[idx];
    }

    @Override
    public AnyType set(int idx, AnyType newVal) {
        if (idx < 0 || idx >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + idx + "; size " + this.size());
        }
        AnyType old = this.theItems[idx];
        this.theItems[idx] = newVal;
        return old;
    }

    @Override
    public boolean contains(Object x) {
        return this.findPos(x) != -1;
    }

    private int findPos(Object x) {
        for (int i = 0; i < this.size(); ++i) {
            if (!(x == null ? this.theItems[i] == null : x.equals(this.theItems[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean add(AnyType x) {
        if (this.theItems.length == this.size()) {
            AnyType[] old = this.theItems;
            this.theItems = new Object[this.theItems.length * 2 + 1];
            for (int i = 0; i < this.size(); ++i) {
                this.theItems[i] = old[i];
            }
        }
        this.theItems[this.theSize++] = x;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object x) {
        int pos = this.findPos(x);
        if (pos == -1) {
            return false;
        }
        this.remove(pos);
        return true;
    }

    public AnyType remove(int idx) {
        AnyType removedItem = this.theItems[idx];
        for (int i = idx; i < this.size() - 1; ++i) {
            this.theItems[i] = this.theItems[i + 1];
        }
        --this.theSize;
        ++this.modCount;
        return removedItem;
    }

    @Override
    public void clear() {
        this.theSize = 0;
        this.theItems = new Object[10];
        ++this.modCount;
    }

    @Override
    public Iterator<AnyType> iterator() {
        return new ArrayListIterator(0);
    }

    @Override
    public ListIterator<AnyType> listIterator(int idx) {
        return new ArrayListIterator(idx);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayListIterator
    implements ListIterator<AnyType> {
        private int current;
        private int expectedModCount;
        private boolean nextCompleted;
        private boolean prevCompleted;

        ArrayListIterator(int pos) {
            this.expectedModCount = ArrayList.this.modCount;
            this.nextCompleted = false;
            this.prevCompleted = false;
            if (pos < 0 || pos > ArrayList.this.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.current = pos;
        }

        @Override
        public boolean hasNext() {
            if (this.expectedModCount != ArrayList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current < ArrayList.this.size();
        }

        @Override
        public boolean hasPrevious() {
            if (this.expectedModCount != ArrayList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current > 0;
        }

        @Override
        public AnyType next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextCompleted = true;
            this.prevCompleted = false;
            return ArrayList.this.theItems[this.current++];
        }

        @Override
        public AnyType previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.prevCompleted = true;
            this.nextCompleted = false;
            return ArrayList.this.theItems[--this.current];
        }

        @Override
        public void remove() {
            if (this.expectedModCount != ArrayList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextCompleted) {
                ArrayList.this.remove(--this.current);
            } else if (this.prevCompleted) {
                ArrayList.this.remove(this.current);
            } else {
                throw new IllegalStateException();
            }
            this.nextCompleted = false;
            this.prevCompleted = false;
            ++this.expectedModCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubList
    extends ArrayList<AnyType> {
        private List<AnyType> original;
        private int offset;
        private int size;

        @Override
        public ArrayList<AnyType> subList(int from, int to) {
            return new SubList(this, from, to);
        }

        public SubList(int from, int to) {
            if (from < 0 || to > ArrayList.this.size()) {
                throw new IllegalArgumentException(from + " " + to + " " + ArrayList.this.size());
            }
            this.original = ArrayList.this;
            this.offset = from;
            this.size = to - from;
        }

        public SubList(SubList sub, int from, int to) {
            if (from < 0 || to > sub.size()) {
                throw new IllegalArgumentException(from + " " + to + " " + sub.size());
            }
            this.original = sub.original;
            this.offset = sub.offset + from;
            this.size = to - from;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public AnyType get(int idx) {
            return this.original.get(this.offset + idx);
        }

        @Override
        public AnyType set(int idx, AnyType x) {
            return this.original.set(this.offset + idx, x);
        }

        @Override
        public boolean add(AnyType x) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AnyType remove(int idx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object x) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object x) {
            for (Object item : this) {
                if (!item.equals(x)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ListIterator<AnyType> listIterator(int idx) {
            return this.original.listIterator(this.offset + idx);
        }

        @Override
        public Iterator<AnyType> iterator() {
            return this.original.listIterator(this.offset);
        }
    }
}

