/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import java.lang.reflect.Array;
import weiss.util.Collection;
import weiss.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollection<AnyType>
implements Collection<AnyType> {
    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] copy = new Object[this.size()];
        int i = 0;
        for (Object val : this) {
            copy[i++] = val;
        }
        return copy;
    }

    @Override
    public <OtherType> OtherType[] toArray(OtherType[] arr) {
        int size = this.size();
        if (arr.length < size) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), size);
        } else if (size < arr.length) {
            arr[size] = null;
        }
        OtherType[] result = arr;
        Iterator itr = this.iterator();
        for (int i = 0; i < size; ++i) {
            result[i] = itr.next();
        }
        return arr;
    }

    @Override
    public boolean contains(Object x) {
        if (x == null) {
            return false;
        }
        for (Object val : this) {
            if (!x.equals(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(AnyType x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object x) {
        if (x == null) {
            return false;
        }
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            if (!x.equals(itr.next())) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Collection)) {
            return false;
        }
        Collection rhs = (Collection)other;
        if (this.size() != rhs.size()) {
            return false;
        }
        Iterator lhsItr = this.iterator();
        Iterator rhsItr = rhs.iterator();
        while (lhsItr.hasNext()) {
            if (this.isEqual(lhsItr.next(), rhsItr.next())) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int hashVal = 1;
        for (Object obj : this) {
            hashVal = 31 * hashVal + (obj == null ? 0 : obj.hashCode());
        }
        return hashVal;
    }

    private boolean isEqual(Object lhs, Object rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        return lhs.equals(rhs);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[ ");
        for (Object obj : this) {
            result.append(obj + " ");
        }
        result.append("]");
        return result.toString();
    }
}

