package polymorphism;

/**
 * This class represents an rocketship with associated expenses
 * related to its initial cost and flight expenses. It also 
 * has a particular name of a pilot who directs it.

 *
 */
public class Rocketship {
	public static final double INITIAL_COST=25000;
	public static final double COST_PER_MILE=500;
	
	private int milesTraveled;
	private String pilotName;
	
	public Rocketship(String pilotName) {
		this.pilotName = pilotName;
	}
	
	public double calculateExpenses() {
		return INITIAL_COST + this.milesTraveled*COST_PER_MILE;
	}
	
	public void travel(int milesToDestination) {
		printWarning();
		this.milesTraveled += milesToDestination;
	}
	
	public void printWarning() {
		System.out.println("Warning! Rocketship about to depart, get inside now!");
	}
	
	public double getMilesTraveled() {
		return this.milesTraveled;
	}
	
	public String getPilotName() {
		return this.pilotName;
	}
}
