package polymorphism;
/** 
 * 
 * This class represents an helicopter with associated expenses
* related to its initial cost and flight expenses. It also 
* has a particular name of a pilot who directs it.
*/
public class Helicopter {
	public static final double INITIAL_COST=5000;
	public static final double COST_PER_MILE=200;
	
	private int milesTraveled;
	private String pilotName;
	
	public Helicopter(String pilotName) {
		this.pilotName = pilotName;
	}
	
	public double calculateExpenses() {
		return INITIAL_COST + this.milesTraveled*COST_PER_MILE;
	}
	

	public void travel(int milesToDestination) {
		printWarning();
		this.milesTraveled += milesToDestination;
	}
	
	public void printWarning() {
		System.out.println("Warning! Helicopter blades are extremely dangerous!");
	}
	
	public double getMilesTraveled() {
		return this.milesTraveled;
	}
	
	public String getPilotName() {
		return this.pilotName;
	}
}
