package polymorphism;

import java.util.ArrayList;
import java.util.List;

/**
 * This program features an airport with vehicles that take off and land.
 * 
 * Your job is to use inheritance and/or interfaces to remove 
 * as much code duplication as you can. 
 * 
 * @author Jason Yoder, Michael Hewner.
 *
 */
public class AirportMain {
	private List<Airplane> airplanes; 
	private List<Helicopter> helicopters; 
	private List<Rocketship> rocketships; 
	
	private Airport localAirport;

	public static void main(String[] args) {
		new AirportMain();
	}

	public AirportMain() {
		this.localAirport = new Airport("Terre Haute");
		makeVehicles();
		reportTotalExpenses();
		giveFlightOrders();
		reportTotalExpenses();
	}

	public void makeVehicles() {
		this.airplanes = new ArrayList<Airplane>();
		this.helicopters = new ArrayList<Helicopter>(); 
		this.rocketships = new ArrayList<Rocketship>(); 
		
		
		this.airplanes.add(new Airplane("Captain A") );
		this.airplanes.add(new Airplane("Captain B") );
		

		this.helicopters.add(new Helicopter("Captain C") );
		this.helicopters.add(new Helicopter("Captain D") );
		
		this.rocketships.add(new Rocketship("Captain E") );
		this.rocketships.add(new Rocketship("Captain F") );
		
		
	
	}
	
	public void giveFlightOrders() {
		// Note: You are allowed to change these 
		// indices if needed to keep the output the 
		// same as the original. (Hint: if you move 
		// all the vehicle to a single list, the indices 
		// below will change from 0,1,0,1,0,1 to 
		// 0,1,2,3,4,5)
		this.localAirport.tellAirplaneToTravel(   this.airplanes.get(0), 200);
		this.localAirport.tellAirplaneToTravel(   this.airplanes.get(1), 100);
		this.localAirport.tellHelicopterToTravel( this.helicopters.get(0), 50);
		this.localAirport.tellHelicopterToTravel( this.helicopters.get(1), 10);
		this.localAirport.tellRocketshipToTravel( this.rocketships.get(0), 1000);
		this.localAirport.tellRocketshipToTravel( this.rocketships.get(1), 500);
	
	
	}
	
	public void reportTotalExpenses() {
		double costs = 0;
		for (Airplane a : this.airplanes) {
			costs += a.calculateExpenses();
		}

		for (Helicopter h : this.helicopters) {
			costs += h.calculateExpenses();
		}

		for (Rocketship r : this.rocketships) {
			costs += r.calculateExpenses();
		}

		System.out.println("There is a total of $"+costs+" in expenses");
	}
	

}