package polymorphism;

/**
 * This class represents an airport which can direct status updates and tell
 * various vehicles to travel some distance
 *
 */
public class Airport {

	private String name;
	
	public Airport(String string) {
		this.name = string;
	}
	
	public void tellAirplaneToTravel(Airplane a, int milesToTravel) {
		System.out.println("Airplane, piloted by "+ a.getPilotName()  +", departing from " + this.name + " for "+milesToTravel+ " miles");
		a.travel(milesToTravel);
	}
	
	public void tellHelicopterToTravel(Helicopter h, int milesToTravel) {
		System.out.println("Helicopter, piloted by "+ h.getPilotName()  +", departing from " + this.name+ " for "+milesToTravel+ " miles");
		h.travel(milesToTravel);
	}
	
	public void tellRocketshipToTravel(Rocketship r, int milesToTravel) {
		System.out.println("Rocketship, piloted by "+ r.getPilotName()  +", departing from " + this.name+ " for "+milesToTravel+ " miles");
		r.travel(milesToTravel);
	}


}
