package polymorphism;

/**
 * This class represents an airplane with associated expenses
 * related to its initial cost and flight expenses. It also 
 * has a particular name of a pilot who directs it.
 *
 */
public class Airplane {
	
	public static final double INITIAL_COST=10000;
	public static final double COST_PER_MILE=100;
	
	private int milesTraveled;
	
	private String pilotName;
	
	public Airplane(String pilotName) {
		this.pilotName = pilotName;
	}
	
	public double calculateExpenses() {
		return INITIAL_COST + this.milesTraveled*COST_PER_MILE;
	}
	
	public void travel(int milesToDestination) {
		printWarning();
		this.milesTraveled += milesToDestination;
	}
	
	public void printWarning() {
		System.out.println("Warning, clear the runway for take-off!");
	}
	
	public double getMilesTraveled() {
		return this.milesTraveled;
	}
	
	public String getPilotName() {
		return this.pilotName;
	}

	
}
