
import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class BankAccountTest {

	@Test
	public void testBasics1() {
		BankAccount b = new BankAccount();
		b.deposit(100);
		b.deposit(50);
		assertEquals(150, b.getBalance(), 0.001);
	}
	
	@Test
	public void testBasics2() {
		BankAccount b = new BankAccount();
		b.setName("Buffalo");
		assertEquals("Buffalo", b.getName());
	}

	@Test
	public void testConstructor1() {
		BankAccount b = new BankAccount("Buffalo");
		assertEquals("Buffalo", b.getName());
	}
	
	@Test
	public void testConstructor2() {
		BankAccount b = new BankAccount("Buffalo",100);
		assertEquals("Buffalo", b.getName());
		assertEquals(100, b.getBalance(), 0.001);
	}
	
	@Test
	public void testConstructor3() {
		/*
		 * This constructor should make a bank account for a 
		 * secret offshore account.
		 * 
		 * Rather than having a normal name, the name should be
		 * Secret Offshore Account #SOME_NUMBER
		 * 
		 * Where SOME_NUMBER is the first paramenter passed to the constructor
		 */
		BankAccount b = new BankAccount(57,10000);
		assertEquals("Secret Offshore Account #57", b.getName());
		assertEquals(10000, b.getBalance(), 0.001);
	}

}
