package edu.roseHulman.csse220.charges;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

/**
 * This class handles mouse events for a space with charges
 * @author Delvin Defoe and Curt Clifton. Created April 12, 2011
 *
 */
public class SpaceClickHandler implements MouseListener {

	// TODO: add fields to this state as needed
	private Space space;
	private double lastX = -1;
	private double lastY = -1;
	private boolean gotPress = false;

	/**
	 * Creates a handler for the given space.
	 *
	 * @param space
	 */
	public SpaceClickHandler(Space space) {
		this.space = space;
	}

	@Override
	public void mouseClicked(MouseEvent e) {
		// TODO: implement mouseClicked to add point charge.
		double x = this.space.convertToSpace(e.getX());
		double y = this.space.convertToSpace(e.getY());
		this.space.addCharge(new PointCharge(x,y,1.0));
		this.space.repaint();
}

	@Override
	public void mouseEntered(MouseEvent e) {
		// ignored
	}

	@Override
	public void mouseExited(MouseEvent e) {
		// ignored
	}

	@Override
	public void mousePressed(MouseEvent e) {
		System.out.printf("Pressed: (%3d, %3d)%n", e.getX(), e.getY());
		// TODO: add state for tracking down event
		this.gotPress = true;
		this.lastX = this.space.convertToSpace(e.getX());
		this.lastY = this.space.convertToSpace(e.getY());
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		System.out.printf("Released: (%3d, %3d)%n", e.getX(), e.getY());
		// TODO: handle release and do the right thing
		if (this.gotPress) {
			this.gotPress = false;
			double x = this.space.convertToSpace(e.getX());
			double y = this.space.convertToSpace(e.getY());
			Charge ch;
			if (this.lastX != x && this.lastY != y) {
				// single click is handled by mouseClicked, so only deal with
				// click and drag here. Add linear charge here.
				ch = new LinearCharge(this.lastX, this.lastY, x, y, 10.0);
				this.space.addCharge(ch);
				this.space.repaint();
			}
		}
	}
}

