package edu.roseHulman.csse220.charges;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * Starts the Charges application.
 * 
 * @author Curt Clifton. Created Oct 3, 2008.
 */
public class ChargeMain {

	private static final int HEIGHT = 600;
	private static final int WIDTH = 900;

	/**
	 * Starts the application.
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		JFrame frame = new JFrame();
		frame.setSize(WIDTH, HEIGHT);
		frame.setTitle("Charge!");

		// TODO: space probably needs to be final
		final Space space = new Space();
		addCharges(space);

		frame.add(space);

		// TODO: add Zoom In and Zoom Out buttons to the GUI.
		JPanel buttonPanel = new JPanel();
		JButton zoomInButton = new JButton("Zoom In");
		buttonPanel.add(zoomInButton);
		JButton zoomOutButton = new JButton("Zoom Out");
		buttonPanel.add(zoomOutButton);
		frame.add(buttonPanel, BorderLayout.SOUTH);

		// TODO: set up action listeners for zoom in and zoom out buttons
		ActionListener inZoomer = new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				space.zoomIn();
			}
		};
		zoomInButton.addActionListener(inZoomer);
		
		ActionListener outZoomer = new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				space.zoomOut();
			}
		};
		zoomOutButton.addActionListener(outZoomer);

		/* TODO: Add mouse listener to allow drawing on the space.  Use 
		 * the SpaceClickHandler class to implement the MouseListener. 
		 */
		MouseListener hearMouse = new SpaceClickHandler(space);
		space.addMouseListener(hearMouse);

		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setVisible(true);
	}

	/**
	 * Adds charges to the given space for simulation purposes.
	 * 
	 * @param space
	 *            the charge space to simulate (mutated)
	 */
	private static void addCharges(Space space) {
		space.addCharge(new PointCharge(10, 10, 3.0));
		space.addCharge(new PointCharge(20, 10, -3.0));

		space.addCharge(new LinearCharge(0, 5, 30, 5, 10.0));
		space.addCharge(new LinearCharge(0, 15, 30, 15, -10.0));
	}

}
