import java.util.Iterator;


/**
 * A Cool class that would be even cooler if
 * it used generics and iterators
 * 
 * It represents a pair of two objects of the same type.
 * Right now it's only a pair of ints, but we want it to
 * be a pair of anythings
 * 
 * @author hewner
 *
 */
public class CoolPair<T> implements Iterable<T>{

	private T first, last;
	
	public CoolPair(T first, T last) {
		this.first = first;
		this.last = last;
	}
	
	public String toString() {
		return "(" + this.first + ", " + this.last + ")";
	}

	private static class PairIterator<Q> implements Iterator<Q> {

		public int currentPos = 0;
		public CoolPair<Q> pair;
		
		@Override
		public boolean hasNext() {
			return currentPos < 2;
		}

		@Override
		public Q next() {
			currentPos++;
			if(currentPos == 1) {
				return pair.first;
			}
			return pair.last;
		}

		@Override
		public void remove() {
			// does nothing for coolpair
			
		}
		
	}
	
	@Override
	public Iterator<T> iterator() {
		PairIterator<T> myIterator = new PairIterator<T>();
		myIterator.pair = this;
		return myIterator;
	}

	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		CoolPair<String> one = new CoolPair<String>("Hello","World");
		CoolPair<Integer> two = new CoolPair<Integer>(1,2);
		System.out.println(one); // prints (Hello, World)
		System.out.println(two); // prints (1, 2)
		
		// prints
		// Hello
		// World
		for(String current : one) {
			System.out.println(current);
		} 
		
		// prints
		// 1
		// 2
		for(int current : two) {
			System.out.println(current);
		} 

	}


}
