import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JButton;


/**
 * ColorSwatches are the colors you see at the bottom of the screen.
 *
 * @author Jared Mathis.
 *         Created Apr 8, 2008.
 */
public class ColorSwatch extends JButton {
	
	/**
	 * Height and width of a ColorSwatch.
	 */
	protected static final int SWATCH_SIZE = 20;
	
	private static final Dimension PREFERRED_SIZE = new Dimension(SWATCH_SIZE, SWATCH_SIZE);
	
	/**
	 * Constructs a ColorSwatch.
	 *
	 * @param color Color of this ColorSwatch
	 * @param colorPanel colorPanel to put this ColorSwatch in.
	 */
	ColorSwatch(Color color, ColorPanel colorPanel) {
		super();
		this.setBackground(color);
		this.addMouseListener(colorPanel);
		this.addMouseListener(colorPanel.paint.toolPanel.viewer);
		this.setPreferredSize(PREFERRED_SIZE);
		colorPanel.add(this);
	}
}
