import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JFrame;


/**
 * Creates the base frame to which everything else is added
 *
 * @author Annmarie Stanley and Hannah Chadd.
 *         Created Mar 30, 2008.
 */
public class PaintFrame extends JFrame {

	/**
	 * Width of frame.
	 */
	public static final int width = 800;
	
	/**
	 * Height of frame.
	 */
	public static final int height = 800;
	

	/**
	 * Create a frame for the whole paint window.
	 * 
	 * @param The number of buttons to draw.
	 */
	@SuppressWarnings("deprecation")
	public PaintFrame() {
		this.setTitle("Paint");
		this.setSize(new Dimension(height, width));
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setLayout(new GridLayout(1,2));
		this.setCursor(this.HAND_CURSOR);
	}		

}
